/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.block_entities.block.RiftBlockEntity;
import divinerpg.blocks.base.PortalBlock;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.UniversalPosition;
import divinerpg.util.Utils;
import divinerpg.world.placement.Surface;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockModRift
extends BaseEntityBlock
implements Portal {
    public static final ResourceLocation ADVANCEMENT_UNSTABLE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"divine/an_unstable_combination");
    public static final ResourceLocation ADVANCEMENT_STABLE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"divine/ripple_space_time");
    public final ResourceKey<Level> rootDimension;
    public final ResourceKey<Level> chainDimension;
    public final TagKey<Block> resonanceTag;
    public final TagKey<Item> empowerTag;
    public final byte variant;
    public static final MapCodec<BlockModRift> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockModRift.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("root_dimension").forGetter(BlockModRift::rootDimension), (App)ResourceLocation.CODEC.fieldOf("chain_dimension").forGetter(BlockModRift::chainDimension), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("supported_blocks").forGetter(BlockModRift::resonanceTag), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("replenishing_items").forGetter(BlockModRift::empowerTag), (App)Codec.BYTE.fieldOf("variant").forGetter(BlockModRift::variant)).apply((Applicative)instance, BlockModRift::new));

    public BlockModRift(BlockBehaviour.Properties properties, ResourceLocation rootDimension, ResourceLocation chainDimension, TagKey<Block> resonanceTag, TagKey<Item> empowerTag, byte variant) {
        this(properties.pushReaction(PushReaction.BLOCK), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rootDimension), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)chainDimension), resonanceTag, empowerTag, variant);
    }

    public BlockModRift(ResourceKey<Level> rootDimension, ResourceKey<Level> chainDimension, TagKey<Block> resonanceTag, TagKey<Item> empowerTag, byte variant) {
        this(BlockBehaviour.Properties.of().replaceable().noCollission().noLootTable().air().strength(-1.0f, 3600000.0f), rootDimension, chainDimension, resonanceTag, empowerTag, variant);
    }

    public BlockModRift(BlockBehaviour.Properties properties, ResourceKey<Level> rootDimension, ResourceKey<Level> chainDimension, TagKey<Block> resonanceTag, TagKey<Item> empowerTag, byte variant) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(15)));
        this.rootDimension = rootDimension;
        this.chainDimension = chainDimension;
        this.resonanceTag = resonanceTag;
        this.empowerTag = empowerTag;
        this.variant = variant;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.is((Block)this)) {
            return;
        }
        if (!newState.isAir()) {
            level.playSound(null, pos, (SoundEvent)SoundRegistry.RIFT_COLSE_MUFFLED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (state.hasBlockEntity()) {
                level.removeBlockEntity(pos);
            }
            return;
        }
        if (state.hasBlockEntity()) {
            if (level instanceof ServerLevel) {
                ServerLevel s = (ServerLevel)level;
                s.sendParticles((ParticleOptions)(switch (((RiftBlockEntity)level.getBlockEntity((BlockPos)pos)).variant & 7) {
                    case 5 -> (SimpleParticleType)ParticleRegistry.MORTUM_RIFT.get();
                    case 4 -> (SimpleParticleType)ParticleRegistry.SKYTHERN_RIFT.get();
                    case 3 -> (SimpleParticleType)ParticleRegistry.APALACHIA_RIFT.get();
                    case 2 -> (SimpleParticleType)ParticleRegistry.WILDWOOD_RIFT.get();
                    default -> (SimpleParticleType)ParticleRegistry.EDEN_RIFT.get();
                }), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
            }
            level.removeBlockEntity(pos);
        }
        if (level.dimension() != this.rootDimension && level.dimension() != this.chainDimension) {
            level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 3.0f, Level.ExplosionInteraction.TNT);
            for (int i = 0; i < 15; ++i) {
                BlockPos p = pos.offset(Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(3) + 1), Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(2) + 1) - 1, Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(3) + 1));
                if (!level.getBlockState(p).isAir()) continue;
                level.setBlock(p, Blocks.FIRE.defaultBlockState(), 3);
            }
        }
        level.playSound(null, pos, (SoundEvent)SoundRegistry.RIFT_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        ServerLevel s;
        if (oldState.is((Block)this)) {
            return;
        }
        RiftBlockEntity e = (RiftBlockEntity)level.getBlockEntity(pos);
        e.variant = this.variant;
        int lifetime = 200;
        List states = level.getBlockStates(new AABB(UniversalPosition.toVec3(pos.offset(-2, -2, -2)), UniversalPosition.toVec3(pos.offset(2, 2, 2)))).toList();
        for (BlockState s2 : states) {
            if (!s2.is(this.resonanceTag)) continue;
            lifetime = lifetime * 5 >> 2;
        }
        e.maxLifeTime = e.lifeTime = lifetime;
        if (level.dimension() != this.rootDimension && level.dimension() != this.chainDimension) {
            e.variant = (byte)(e.variant | 0x10);
            level.explode(null, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 5.0f, Level.ExplosionInteraction.TNT);
            for (int i = 0; i < 15; ++i) {
                BlockPos p = pos.offset(Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(3) + 1), Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(2) + 1) - 1, Mth.sign((double)(Math.random() - 0.5)) * (level.random.nextInt(3) + 1));
                if (!level.getBlockState(p).isAir()) continue;
                level.setBlock(p, Blocks.FIRE.defaultBlockState(), 3);
            }
            if (level instanceof ServerLevel) {
                ServerLevel s3 = (ServerLevel)level;
                List<ServerPlayer> players = Utils.getNearbyPlayers(s3, pos.getX(), pos.getY(), pos.getZ(), 9.0);
                for (ServerPlayer player : players) {
                    Utils.awardAdvancement(s3.getServer(), player, ADVANCEMENT_UNSTABLE, "create_unstable_rift");
                }
            }
        } else if (level instanceof ServerLevel) {
            s = (ServerLevel)level;
            List<ServerPlayer> players = Utils.getNearbyPlayers(s, pos.getX(), pos.getY(), pos.getZ(), 9.0);
            for (ServerPlayer player : players) {
                Utils.awardAdvancement(s.getServer(), player, ADVANCEMENT_STABLE, "create_stable_rift");
            }
        }
        level.playSound(null, pos, (SoundEvent)SoundRegistry.RIFT_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            s = (ServerLevel)level;
            s.sendParticles((ParticleOptions)(switch (e.variant & 7) {
                case 5 -> (SimpleParticleType)ParticleRegistry.MORTUM_RIFT.get();
                case 4 -> (SimpleParticleType)ParticleRegistry.SKYTHERN_RIFT.get();
                case 3 -> (SimpleParticleType)ParticleRegistry.APALACHIA_RIFT.get();
                case 2 -> (SimpleParticleType)ParticleRegistry.WILDWOOD_RIFT.get();
                default -> (SimpleParticleType)ParticleRegistry.EDEN_RIFT.get();
            }), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ItemEntity e;
        if (entity instanceof ItemEntity && (e = (ItemEntity)entity).getItem().is(this.empowerTag)) {
            e.discard();
            RiftBlockEntity r = (RiftBlockEntity)level.getBlockEntity(pos);
            r.lifeTime = r.maxLifeTime;
            level.playSound(null, pos, (SoundEvent)SoundRegistry.RIFT_REPLENISH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (level.dimension() != this.rootDimension) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? BlockModRift.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.RIFT.get()), RiftBlockEntity::clientTick) : BlockModRift.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.RIFT.get()), RiftBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegistry.RIFT.get()).create(blockPos, blockState);
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        BlockPos targetPosition;
        ItemEntity e;
        if (level.dimension() == this.rootDimension || entity instanceof ItemEntity && (e = (ItemEntity)entity).getItem().is(this.empowerTag)) {
            return null;
        }
        ServerLevel targetLevel = level.getServer().getLevel(this.rootDimension);
        pos = targetPosition = PortalBlock.scalePosition(pos, level.dimensionType(), targetLevel.dimensionType());
        for (int tries = 0; tries < 10 && !this.hasRoom(targetLevel, pos = this.applyLocationPreference(targetLevel, entity, pos)); ++tries) {
            pos = tries == 9 ? targetPosition : targetPosition.offset((int)((entity.getRandom().nextFloat() - 0.5f) * (float)(tries << 2)), 0, (int)((entity.getRandom().nextFloat() - 0.5f) * (float)(tries << 2)));
        }
        targetPosition = pos;
        BlockState state = targetLevel.getBlockState(pos = targetPosition.below());
        if (state.is((Block)this)) {
            return this.transitionTo(level.getServer(), entity, new UniversalPosition(this.rootDimension, pos));
        }
        if (!state.isFaceSturdy((BlockGetter)targetLevel, pos, Direction.UP)) {
            targetLevel.setBlock(pos, ((Block)BlockRegistry.twilightStone.get()).defaultBlockState(), 3);
        }
        targetLevel.setBlock(targetPosition, Blocks.AIR.defaultBlockState(), 3);
        targetLevel.setBlock(targetPosition.above(), Blocks.AIR.defaultBlockState(), 3);
        targetLevel.setBlock(targetPosition.above(2), this.defaultBlockState(), 3);
        return this.transitionTo(level.getServer(), entity, new UniversalPosition(this.rootDimension, targetPosition));
    }

    public DimensionTransition transitionTo(MinecraftServer server, Entity entity, UniversalPosition pos) {
        return new DimensionTransition(pos.level(server), pos.pos().add(0.5, 0.0, 0.5), Vec3.ZERO, entity.getYRot(), entity.getXRot(), false, DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET).then(e -> e.hurt(e.damageSources().inWall(), e.level().dimension() == this.chainDimension ? 1.0f : 18.0f)));
    }

    public BlockPos applyLocationPreference(ServerLevel level, Entity entity, BlockPos pos) {
        return new BlockPos(pos.getX(), Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight() + 1, level.dimensionType().logicalHeight(), 0, (WorldGenLevel)level, level.getRandom(), pos.getX(), pos.getZ()), pos.getZ());
    }

    public boolean hasRoom(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos).isAir() && level.getBlockState(pos.above()).isAir() && level.getBlockState(pos.above(2)).isAir();
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = Math.max(1, level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        } else {
            n = 0;
        }
        return n;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)BlockStateProperties.LEVEL);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.LEVEL});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ResourceLocation rootDimension() {
        return this.rootDimension.location();
    }

    public ResourceLocation chainDimension() {
        return this.chainDimension.location();
    }

    public TagKey<Block> resonanceTag() {
        return this.resonanceTag;
    }

    public TagKey<Item> empowerTag() {
        return this.empowerTag;
    }

    public byte variant() {
        return this.variant;
    }
}

