/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.PortalBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.UniversalPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockGateway
extends BaseEntityBlock
implements Portal {
    public static final MapCodec<BlockGateway> CODEC = BlockGateway.simpleCodec(BlockGateway::new);

    public MapCodec<BlockGateway> codec() {
        return CODEC;
    }

    public BlockGateway(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.BASS));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        ServerLevel serverLevel;
        DimensionTransition d;
        if (!entity.isOnPortalCooldown() && level instanceof ServerLevel && (d = this.getPortalDestination(serverLevel = (ServerLevel)level, entity, pos)) != null) {
            level.playSound(null, pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS);
            entity.changeDimension(d);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (stack.is(ItemRegistry.teleportation_star) && (blockEntity = level.getBlockEntity(pos)) instanceof PortalBlockEntity) {
            PortalBlockEntity portal = (PortalBlockEntity)blockEntity;
            if (stack.has(DataComponentRegistry.dimension) && stack.has(DataComponentRegistry.position)) {
                portal.targetPosition = new UniversalPosition((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)stack.get(DataComponentRegistry.dimension))), (BlockPos)stack.get(DataComponentRegistry.position));
                level.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS);
                player.getCooldowns().addCooldown(stack.getItem(), 40);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel serverLevel, Entity entity, BlockPos blockPos) {
        ServerLevel targetLevel;
        PortalBlockEntity portal;
        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof PortalBlockEntity && (portal = (PortalBlockEntity)blockEntity).hasTargetPos() && (targetLevel = portal.targetPosition.level(serverLevel.getServer())).getBlockState(portal.targetPosition.blockPos().below()).is(TagRegistry.GATEWAY_RECEIVER)) {
            return new DimensionTransition(targetLevel, portal.targetPosition.blockPosVec().add(0.5, 0.0, 0.5), entity.getKnownMovement(), entity.getYRot(), entity.getXRot(), false, DimensionTransition.DO_NOTHING.then(e -> e.level().playSound(null, e.getX(), e.getY(), e.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 0.7f, 1.0f)).then(e -> e.setPortalCooldown(40)));
        }
        return null;
    }
}

