/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockElevantium
extends BlockMod {
    protected static final VoxelShape ELEVANTIUM = Shapes.or((VoxelShape)BlockElevantium.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)BlockElevantium.box((double)4.5, (double)1.0, (double)4.5, (double)11.5, (double)2.0, (double)11.5));

    public BlockElevantium() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).mapColor(MapColor.COLOR_LIGHT_BLUE).pushReaction(PushReaction.DESTROY));
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        int signal = world.getBestNeighborSignal(pos);
        if (signal > 0) {
            entity.addDeltaMovement(new Vec3(0.0, (double)signal * 0.25, 0.0));
            entity.hasImpulse = true;
            world.playSound(null, pos, (SoundEvent)SoundRegistry.CONSTRUCTOR_PUNCH.get(), SoundSource.BLOCKS, 0.75f, 0.9f);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ELEVANTIUM;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.create((AABB)ELEVANTIUM.bounds().inflate(0.0625, 0.125, 0.0625));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }
}

