/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.block_entities.block.PortalBlockEntity;
import divinerpg.blocks.base.PortalBlock;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.UniversalPosition;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockArcanaPortal
extends PortalBlock {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public BlockArcanaPortal() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_PORTAL), LevelRegistry.ARCANA, (ResourceKey<Level>)Level.OVERWORLD, (Block)BlockRegistry.arcanaPortalFrame.get(), null);
        this.registerDefaultState((BlockState)this.stateDefinition.any());
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public boolean isSupported(BlockState state, LevelReader level, BlockPos pos) {
        return this.supportedBy(level.getBlockState(pos.north())) && this.supportedBy(level.getBlockState(pos.east())) && this.supportedBy(level.getBlockState(pos.south())) && this.supportedBy(level.getBlockState(pos.west()));
    }

    @Override
    public BlockPos applyPlacementLocationPreference(ServerLevel level, Entity entity, BlockPos pos) {
        BlockPos ruinedPortal;
        if (level.dimension() == this.rootDimension && (ruinedPortal = this.repairRuinedPortal(level, level.findNearestMapStructure(StructureTags.RUINED_PORTAL, pos, 128, false))) != null) {
            return ruinedPortal;
        }
        return super.applyPlacementLocationPreference(level, entity, pos);
    }

    @Override
    public BlockPos placePortal(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        if (level.dimension() == this.rootDimension && level.getBlockState(pos.offset(2, 0, 2)).is((Block)this)) {
            return pos;
        }
        Block frame = (Block)BlockRegistry.arcanaPortalFrame.get();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (Math.abs(x) < 2 && Math.abs(z) < 2) {
                    level.setBlock(pos.offset(x, 0, z), this.defaultBlockState(), 3);
                    continue;
                }
                if (Math.abs(z) < 2) {
                    if (x == -2) {
                        level.setBlock(pos.offset(x, 0, z), (BlockState)frame.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST), 3);
                        continue;
                    }
                    if (x != 2) continue;
                    level.setBlock(pos.offset(x, 0, z), (BlockState)frame.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST), 3);
                    continue;
                }
                if (Math.abs(x) >= 2) continue;
                if (z == -2) {
                    level.setBlock(pos.offset(x, 0, z), (BlockState)frame.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH), 3);
                    continue;
                }
                level.setBlock(pos.offset(x, 0, z), (BlockState)frame.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH), 3);
            }
        }
        return pos;
    }

    private BlockPos repairRuinedPortal(ServerLevel level, BlockPos position) {
        if (position == null) {
            return null;
        }
        int surface = Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 33, 255, 0, (WorldGenLevel)level, null, position.getX(), position.getZ());
        for (int x = position.getX() - 11; x < position.getX() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.getZ() - 11; z < position.getZ() + 11; ++z) {
                    if (!level.getBlockState(new BlockPos(x, y, z)).is((Block)this)) continue;
                    return new BlockPos(x, y, z);
                }
            }
        }
        BlockPos pos = null;
        Block tile = (Block)BlockRegistry.ancientTile.get();
        block3: for (int x = position.getX() - 11; x < position.getX() + 11; ++x) {
            for (int y = surface - 7; y < surface + 7; ++y) {
                for (int z = position.getZ() - 11; z < position.getZ() + 11; ++z) {
                    pos = new BlockPos(x, y, z);
                    if (!level.getBlockState(pos).is(tile)) continue;
                    Block brick = (Block)BlockRegistry.lightDegradedBrick.get();
                    pos = level.getBlockState(pos.offset(-1, 0, -1)).is(brick) ? pos.offset(-5, 0, -5) : (level.getBlockState(pos.offset(1, 0, -1)).is(brick) ? pos.offset(-1, 0, -5) : (level.getBlockState(pos.offset(-1, 0, 1)).is(brick) ? pos.offset(-5, 0, -1) : (level.getBlockState(pos.offset(1, 0, 1)).is(brick) ? pos.offset(-1, 0, -1) : null)));
                    break block3;
                }
            }
        }
        if (pos == null) {
            return null;
        }
        level.getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana/portal")).placeInWorld((ServerLevelAccessor)level, pos, pos, new StructurePlaceSettings(), level.random, 2);
        return new BlockPos(pos.getX() + 4, pos.getY() + 1, pos.getZ() + 4);
    }

    @Override
    public void linkPortals(MinecraftServer server, UniversalPosition origin, UniversalPosition target) {
        if (!BlockArcanaPortal.hasPortal(server, origin) || !BlockArcanaPortal.hasPortal(server, target)) {
            return;
        }
        this.connectTo(origin.level(server), origin.blockPos(), target, null);
        this.connectTo(target.level(server), target.blockPos(), origin, null);
    }

    @Override
    public void connectTo(ServerLevel level, BlockPos pos, @NotNull UniversalPosition connection, Direction.Axis axis) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PortalBlockEntity) {
            PortalBlockEntity portal = (PortalBlockEntity)blockEntity;
            if (!connection.equals(portal.targetPosition)) {
                portal.targetPosition = connection;
                this.connectTo(level, pos.north(), connection, axis);
                this.connectTo(level, pos.east(), connection, axis);
                this.connectTo(level, pos.south(), connection, axis);
                this.connectTo(level, pos.west(), connection, axis);
            }
        }
    }
}

