/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TerranGhostBlockEntity
extends BlockEntity {
    public int lifeTime = 300;
    public BlockState originalState;

    public TerranGhostBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.TERRAN_GHOST.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("lifetime", this.lifeTime);
        if (this.originalState != null) {
            tag.put("originalstate", (Tag)NbtUtils.writeBlockState((BlockState)this.originalState));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("lifetime")) {
            this.lifeTime = tag.getInt("lifetime");
        }
        if (tag.contains("originalstate")) {
            this.originalState = NbtUtils.readBlockState((HolderGetter)registries.lookupOrThrow(Registries.BLOCK), (CompoundTag)tag.getCompound("originalstate"));
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TerranGhostBlockEntity entity) {
        --entity.lifeTime;
        if (entity.lifeTime <= 0) {
            level.setBlock(pos, entity.originalState == null ? Blocks.AIR.defaultBlockState() : entity.originalState, 3);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TerranGhostBlockEntity entity) {
        RandomSource random = level.getRandom();
        if (random.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleRegistry.GREEN_FLAME.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

