/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.registries.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ProximitySpawnerBlockEntity
extends BlockEntity {
    private static final String ENTITY_NAME_TAG = "drpgentityname";
    public String entityName;

    public ProximitySpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.PROXIMITY_SPAWNER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ProximitySpawnerBlockEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (entity.entityName != null && world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 25.0, EntitySelector.NO_CREATIVE_OR_SPECTATOR) != null) {
                world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entity.entityName.indexOf(58) == -1 ? ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)entity.entityName) : ResourceLocation.parse((String)entity.entityName))).spawn(world, pos, MobSpawnType.SPAWNER);
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.entityName != null) {
            tag.putString(ENTITY_NAME_TAG, this.entityName);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(ENTITY_NAME_TAG)) {
            this.entityName = tag.getString(ENTITY_NAME_TAG);
        }
    }
}

