/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.block_entities.block.InserterBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class OxcrateBlockEntity
extends BlockEntity
implements Hopper {
    private Item item;
    private ItemStack tempstack = ItemStack.EMPTY;
    private int cooldown = 6;

    public OxcrateBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.OXCRATE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OxcrateBlockEntity block) {
        if (block.item != null && ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            if (block.cooldown < 1) {
                if (HopperBlockEntity.suckInItems((Level)level, (Hopper)block)) {
                    block.cooldown = 6;
                }
            } else {
                --block.cooldown;
            }
        }
    }

    public void setItem(ItemStack item) {
        this.item = item == null || item.isEmpty() ? null : item.getItem();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.item != null) {
            tag.put("item", new ItemStack((ItemLike)this.item).save(registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item")) {
            this.item = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item")).getItem();
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (stack.is(this.item)) {
            this.tempstack = stack;
            return InserterBlockEntity.ejectItems(this.level, this.worldPosition, this, Direction.DOWN);
        }
        return false;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return predicate.test(this.tempstack);
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public boolean isGridAligned() {
        return false;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int i) {
        return this.tempstack;
    }

    public ItemStack removeItem(int i, int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        ItemStack s = this.tempstack;
        this.tempstack = ItemStack.EMPTY;
        return s;
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack s = this.tempstack;
        this.tempstack = ItemStack.EMPTY;
        return s;
    }

    public boolean canTakeItem(Container c, int i, ItemStack s) {
        return (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.ENABLED);
    }

    public int countItem(Item i) {
        return 0;
    }

    public void setItem(int i, ItemStack itemStack) {
        this.tempstack = itemStack == null ? ItemStack.EMPTY : itemStack;
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator();
    }

    public void clearContent() {
        this.tempstack = ItemStack.EMPTY;
    }
}

