/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.blocks.vethea.BlockDreamLamp;
import divinerpg.client.menu.DreamLampMenu;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DreamLampBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int[] SLOTS = new int[]{0};
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int i) {
            return DreamLampBlockEntity.this.burntime;
        }

        public void set(int type, int value) {
            DreamLampBlockEntity.this.burntime = value;
        }

        public int getCount() {
            return 1;
        }
    };
    int burntime;

    public DreamLampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.DREAM_LAMP.get(), pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DreamLampBlockEntity block) {
        if (block.burntime < 0) {
            ItemStack fuel = (ItemStack)block.items.get(0);
            if (fuel.is((Item)ItemRegistry.acid.get())) {
                fuel.shrink(1);
                block.burntime += 600;
                state = (BlockState)state.setValue((Property)BlockDreamLamp.POWERED, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, state, 3);
                DreamLampBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else {
            --block.burntime;
            if (block.burntime < 0 && !((ItemStack)block.items.get(0)).is((Item)ItemRegistry.acid.get())) {
                state = (BlockState)state.setValue((Property)BlockDreamLamp.POWERED, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 3);
                DreamLampBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return ((ItemStack)this.items.get(0)).isEmpty();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public ItemStack getItem(int i) {
        return (ItemStack)this.items.get(0);
    }

    public ItemStack removeItem(int i, int j) {
        return ContainerHelper.removeItem(this.items, (int)i, (int)j);
    }

    public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.items, (int)i);
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.items.clear();
    }

    public int[] getSlotsForFace(Direction dir) {
        return SLOTS;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack stack, Direction dir) {
        return true;
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack stack, Direction dir) {
        return this.canPlaceItem(i, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot > 0 || stack.is((Item)ItemRegistry.acid.get());
    }

    protected Component getDefaultName() {
        return Component.translatable((String)((Block)BlockRegistry.dreamLamp.get()).getDescriptionId());
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inv) {
        return new DreamLampMenu(i, inv, (Container)this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.burntime = tag.getInt("burntime");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("burntime", this.burntime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
    }
}

