/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.block_entities.block.InserterBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;

public class DistributorBlockEntity
extends InserterBlockEntity {
    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends InserterBlockEntity>)((BlockEntityType)BlockEntityRegistry.DISTRIBUTOR.get()), pos, state);
    }

    @Override
    public void setBlockState(BlockState blockState) {
        this.oldSetBlockState(blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DistributorBlockEntity block) {
        if (!block.isEmpty() && ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            if (block.cooldown < 1) {
                for (int i = 0; i < 5; ++i) {
                    BlockPos p;
                    switch (block.facing) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case DOWN: 
                        case UP: {
                            block.facing = Direction.NORTH;
                            BlockPos blockPos = pos.north();
                            break;
                        }
                        case NORTH: {
                            block.facing = Direction.EAST;
                            BlockPos blockPos = pos.east();
                            break;
                        }
                        case EAST: {
                            block.facing = Direction.SOUTH;
                            BlockPos blockPos = pos.south();
                            break;
                        }
                        case SOUTH: {
                            block.facing = Direction.WEST;
                            BlockPos blockPos = pos.west();
                            break;
                        }
                        case WEST: {
                            block.facing = Direction.DOWN;
                            BlockPos blockPos = p = pos;
                        }
                    }
                    if (level.getBlockState(p).is(BlockRegistry.distributor) && DistributorBlockEntity.eject(level, p, block)) break;
                }
                block.cooldown = 6;
            } else {
                --block.cooldown;
            }
        }
    }

    static boolean eject(Level level, BlockPos pos, DistributorBlockEntity blockEntity) {
        if (DistributorBlockEntity.insertHook(blockEntity, pos)) {
            return true;
        }
        Container container = DistributorBlockEntity.getAttachedContainer(level, pos, Direction.DOWN);
        if (container == null) {
            return false;
        }
        if (DistributorBlockEntity.isFullContainer(container, Direction.UP)) {
            return false;
        }
        ItemStack itemstack = blockEntity.getItem();
        if (!itemstack.isEmpty()) {
            int j = itemstack.getCount();
            ItemStack itemstack1 = HopperBlockEntity.addItem((Container)blockEntity, (Container)container, (ItemStack)blockEntity.removeItem(1), (Direction)Direction.UP);
            if (itemstack1.isEmpty()) {
                container.setChanged();
                return true;
            }
            itemstack.setCount(j);
            if (j == 1) {
                blockEntity.setItem(itemstack);
            }
        }
        return false;
    }

    static boolean insertHook(DistributorBlockEntity hopper, BlockPos pos) {
        return DistributorBlockEntity.getAttachedItemHandler(hopper.getLevel(), pos, Direction.DOWN).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            if (DistributorBlockEntity.isFull(itemHandler)) {
                return false;
            }
            if (!hopper.getItem().isEmpty()) {
                ItemStack originalSlotContents = hopper.getItem().copy();
                ItemStack insertStack = hopper.removeItem(1);
                ItemStack remainder = DistributorBlockEntity.putStackInInventoryAllSlots(itemHandler, insertStack);
                if (remainder.isEmpty()) {
                    return true;
                }
                hopper.setItem(originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putByte("split_order", (byte)this.facing.ordinal());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("split_order")) {
            this.facing = Direction.values()[tag.getByte("split_order")];
        }
    }
}

