/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.registries.BlockEntityRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CrateBlockEntity
extends BlockEntity
implements Hopper {
    private ItemStack stack = ItemStack.EMPTY;
    private int cooldown = 6;

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CRATE.get(), pos, state);
    }

    public boolean isGridAligned() {
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrateBlockEntity block) {
        if (!block.isEmpty() && ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            if (block.cooldown < 1) {
                if (HopperBlockEntity.suckInItems((Level)level, (Hopper)block)) {
                    block.cooldown = 6;
                }
            } else {
                --block.cooldown;
            }
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stack != null && !this.stack.isEmpty()) {
            tag.put("item", this.getItem().save(registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item"));
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    protected ItemStack getItem() {
        return this.stack;
    }

    public ItemStack getItem(int i) {
        return this.stack;
    }

    public ItemStack removeItem(int i, int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        int c = this.stack.getCount();
        if (amount > c) {
            ItemStack s = this.stack;
            this.stack = ItemStack.EMPTY;
            return s;
        }
        ItemStack s = this.stack.copyWithCount(amount);
        this.stack.setCount(this.stack.getCount() - amount);
        return s;
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack s = this.stack;
        this.stack = ItemStack.EMPTY;
        return s;
    }

    public void setItem(int i, ItemStack s) {
        this.stack = s == null ? ItemStack.EMPTY : s;
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator();
    }

    public void setRemoved() {
        super.setRemoved();
        this.stack = ItemStack.EMPTY;
    }

    public int countItem(Item i) {
        return this.stack.is(i) ? this.stack.getCount() : 0;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return predicate.test(this.stack);
    }

    public boolean canTakeItem(Container c, int i, ItemStack s) {
        return this.stack.getCount() > 1 && (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.ENABLED) != false;
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }
}

