/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.network;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.client.ClientEventHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GunStateResponsePacket {
    protected UUID stateId;
    protected int slotIndex;
    protected int correlationId;
    protected boolean isSuccess;

    public GunStateResponsePacket() {
    }

    public GunStateResponsePacket(UUID stateId, int slotIndex, int correlationId, boolean isSuccess) {
        this.stateId = stateId;
        this.slotIndex = slotIndex;
        this.correlationId = correlationId;
        this.isSuccess = isSuccess;
    }

    public static <T extends GunStateResponsePacket> void encode(T packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.stateId.getMostSignificantBits());
        buffer.writeLong(packet.stateId.getLeastSignificantBits());
        buffer.writeInt(packet.slotIndex);
        buffer.writeInt(packet.correlationId);
        buffer.writeBoolean(packet.isSuccess);
        packet.doEncode(buffer);
    }

    protected void doEncode(FriendlyByteBuf buffer) {
    }

    protected static GunStateResponsePacket decodeHeader(FriendlyByteBuf buffer) {
        UUID stateId = new UUID(buffer.readLong(), buffer.readLong());
        int slotIndex = buffer.readInt();
        int correlationId = buffer.readInt();
        boolean isSuccess = buffer.readBoolean();
        return new GunStateResponsePacket(stateId, slotIndex, correlationId, isSuccess);
    }

    public static <T extends GunStateResponsePacket> void handle(T packet, NetworkService.MessageContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ClientUtil.getClientPlayer();
            ClientEventHandler.runSyncTick(() -> {
                Tuple<ItemStack, GunClientState> targetTuple = packet.getItemStackAndState(packet, (Entity)player);
                if (targetTuple != null) {
                    packet.handleEnqueued(ctx, (ItemStack)targetTuple.getA(), (GunClientState)targetTuple.getB());
                }
            });
        });
        ctx.setPacketHandled(true);
    }

    protected <T extends GunStateResponsePacket> Tuple<ItemStack, GunClientState> getItemStackAndState(T packet, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return InventoryUtils.getItemStackByStateId(player, packet.stateId, packet.slotIndex);
        }
        return null;
    }

    protected <T extends GunStateResponsePacket> void handleEnqueued(NetworkService.MessageContext ctx, ItemStack itemStack, GunClientState gunClientState) {
    }
}

