/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.feature;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.ConditionalFeature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.util.Conditions;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PipFeature
extends ConditionalFeature {
    private final float zoom;
    private final ResourceLocation overlayTexture;
    private final ResourceLocation maskTexture;
    private final boolean isParallaxEnabled;

    private PipFeature(FeatureProvider owner, Predicate<ConditionContext> condition, float zoom, boolean isParallaxEnabled, ResourceLocation overlayTexture, ResourceLocation maskTexture) {
        super(owner, condition);
        this.zoom = zoom;
        this.isParallaxEnabled = isParallaxEnabled;
        this.overlayTexture = overlayTexture;
        this.maskTexture = maskTexture;
    }

    public MutableComponent getDescription() {
        return Component.translatable((String)"description.pointblank.enablesPipWithZoom").append((Component)Component.literal((String)String.format(" %.0f%%", Float.valueOf(this.zoom * 100.0f))));
    }

    public float getZoom() {
        return this.zoom;
    }

    public ResourceLocation getMaskTexture() {
        return this.maskTexture;
    }

    public boolean isParallaxEnabled() {
        return this.isParallaxEnabled;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public static Optional<Float> getZoom(ItemStack itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = null;
        selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.getItem();
        if (item instanceof FeatureProvider && (feature = (fp = (FeatureProvider)item).getFeature(PipFeature.class)) != null) {
            return Optional.of(Float.valueOf(feature.getZoom()));
        }
        return Optional.empty();
    }

    public static ResourceLocation getMaskTexture(ItemStack itemStack) {
        FeatureProvider fp;
        PipFeature feature;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = null;
        selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        Item item = selectedStack.getItem();
        if (item instanceof FeatureProvider && (feature = (fp = (FeatureProvider)item).getFeature(PipFeature.class)) != null) {
            return feature.getMaskTexture();
        }
        return null;
    }

    public static PipFeature getSelected(ItemStack itemStack) {
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack selectedStack = null;
        if (selected == null) {
            return null;
        }
        selectedStack = (ItemStack)selected.getSecond();
        Item item = selectedStack.getItem();
        if (item instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)item;
            return fp.getFeature(PipFeature.class);
        }
        return null;
    }

    public static class Builder
    implements FeatureBuilder<Builder, PipFeature> {
        private static final float DEFAULT_ZOOM = 0.9f;
        private static final String DEFAULT_MASK_TEXTURE = "textures/gui/pip_mask_solid_rect.png";
        private Predicate<ConditionContext> condition = ctx -> true;
        private ResourceLocation overlayTexture;
        private ResourceLocation maskTexture;
        private float zoom;
        private boolean isParallaxEnabled;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withZoom(double zoom) {
            this.zoom = (float)zoom;
            return this;
        }

        public Builder withOverlayTexture(String texture) {
            this.overlayTexture = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture);
            return this;
        }

        public Builder withMaskTexture(String texture) {
            this.maskTexture = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture);
            return this;
        }

        public Builder withParallaxEnabled(boolean isParallaxEnabled) {
            this.isParallaxEnabled = isParallaxEnabled;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            String maskTextureName;
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson(obj.get("condition")));
            }
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            this.isParallaxEnabled = JsonUtil.getJsonBoolean(obj, "parallax", false);
            String overlayTextureName = JsonUtil.getJsonString(obj, "overlayTexture", null);
            if (overlayTextureName != null) {
                this.withOverlayTexture(overlayTextureName);
            }
            if ((maskTextureName = JsonUtil.getJsonString(obj, "maskTexture", null)) == null && this.isParallaxEnabled) {
                maskTextureName = DEFAULT_MASK_TEXTURE;
            }
            if (maskTextureName != null) {
                this.withMaskTexture(maskTextureName);
            }
            this.withZoom(JsonUtil.getJsonFloat(obj, "zoom", 0.9f));
            return this;
        }

        @Override
        public PipFeature build(FeatureProvider featureProvider) {
            ResourceLocation maskTexture = this.maskTexture;
            if (maskTexture == null && this.isParallaxEnabled) {
                maskTexture = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)DEFAULT_MASK_TEXTURE);
            }
            return new PipFeature(featureProvider, this.condition, this.zoom, this.isParallaxEnabled, this.overlayTexture, maskTexture);
        }
    }
}

