/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.controller;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateListener;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.ClientUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;

public class GunStateAnimationController
extends AnimationController<GunItem>
implements GunStateListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private final RawAnimation animation;
    private Predicate<ConditionContext> shouldAnimate;
    private Deque<Action> pendingActions = new ArrayDeque<Action>();
    private String animationName;
    private Map<String, RawAnimation> animations = new HashMap<String, RawAnimation>();

    public GunStateAnimationController(GunItem animatable, String controllerName, String animationName, Predicate<ConditionContext> shouldAnimate) {
        super((GeoAnimatable)animatable, controllerName, (AnimationController.AnimationStateHandler)new StateHandler());
        this.animation = RawAnimation.begin().then(animationName, Animation.LoopType.PLAY_ONCE);
        this.animations.put(animationName, this.animation);
        this.animationName = animationName;
        this.shouldAnimate = shouldAnimate;
    }

    RawAnimation getAnimation(String animationName) {
        return this.animations.computeIfAbsent(animationName, n -> RawAnimation.begin().then(animationName, Animation.LoopType.PLAY_ONCE));
    }

    public void scheduleReset(LivingEntity player, GunClientState state, ItemStack itemStack, String animationName) {
        this.pendingActions.addLast(new ResetAction(animationName != null ? animationName : this.animationName));
    }

    public void scheduleReset(LivingEntity player, GunClientState state, ItemStack itemStack) {
        this.scheduleReset(player, state, itemStack, this.animationName);
    }

    private static class StateHandler
    implements AnimationController.AnimationStateHandler<GunItem> {
        private PlayState currentPlayState;

        private StateHandler() {
        }

        public PlayState handle(AnimationState<GunItem> state) {
            boolean isMainHand;
            GunStateAnimationController controller = this.getThisController(state);
            while (!controller.pendingActions.isEmpty()) {
                Action action = controller.pendingActions.removeFirst();
                action.execute(state);
            }
            ItemDisplayContext perspective = (ItemDisplayContext)state.getData(DataTickets.ITEM_RENDER_PERSPECTIVE);
            if (perspective != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return PlayState.STOP;
            }
            ItemStack itemStack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            Player player = ClientUtil.getClientPlayer();
            GunClientState gunClientState = null;
            UUID itemStackId = GunItem.getItemStackId(itemStack);
            boolean bl = isMainHand = itemStackId != null && Objects.equals(GunItem.getItemStackId(player.getMainHandItem()), itemStackId);
            if (player != null && isMainHand && itemStack != null && itemStack.getItem() instanceof GunItem) {
                gunClientState = GunClientState.getState(player, itemStack, -1, false);
                boolean shouldAnimate = false;
                if (gunClientState != null && (shouldAnimate = controller.shouldAnimate.test(new ConditionContext((LivingEntity)player, itemStack, gunClientState, perspective)))) {
                    return this.setPlayState(PlayState.CONTINUE, controller);
                }
                if (gunClientState != null && this.currentPlayState == null) {
                    LOGGER.debug("{} {} cannot continue playing. Should animate: {}, iter: {}", (Object)(System.currentTimeMillis() % 100000L), (Object)controller.getName(), (Object)shouldAnimate, (Object)gunClientState.getReloadIterationIndex());
                }
            }
            return this.setPlayState(PlayState.STOP, controller);
        }

        private PlayState setPlayState(PlayState playState, GunStateAnimationController controller) {
            if (playState != this.currentPlayState) {
                LOGGER.debug("{} {} updated play state from {} to {}", (Object)(System.currentTimeMillis() % 100000L), (Object)controller.getName(), (Object)this.currentPlayState, (Object)playState);
            }
            this.currentPlayState = playState;
            return this.currentPlayState;
        }

        private GunStateAnimationController getThisController(AnimationState<GunItem> state) {
            return (GunStateAnimationController)state.getController();
        }
    }

    private class ResetAction
    implements Action {
        private String animationName;

        ResetAction(String animationName) {
            this.animationName = animationName;
        }

        @Override
        public void execute(AnimationState<GunItem> state) {
            Animation a;
            GeoModel model = GunStateAnimationController.this.lastModel;
            if (model != null && (a = model.getAnimation((GeoAnimatable)((GunItem)GunStateAnimationController.this.animatable), this.animationName)) != null) {
                LOGGER.debug("{} {} resetting animation {}", (Object)(System.currentTimeMillis() % 100000L), (Object)GunStateAnimationController.this.getName(), (Object)this.animationName);
                ((StateHandler)((GunStateAnimationController)GunStateAnimationController.this).stateHandler).currentPlayState = null;
                state.resetCurrentAnimation();
                GunStateAnimationController.this.setAnimation(GunStateAnimationController.this.getAnimation(this.animationName));
            }
        }
    }

    private static interface Action {
        public void execute(AnimationState<GunItem> var1);
    }
}

