/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.uma_maid.utils;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tracen.uma_maid.client.UmamusumeTLMModel;

@OnlyIn(value=Dist.CLIENT)
public class TLMClientUtils {
    public static final HashMap<ResourceLocation, UmamusumeTLMModel> MODEL_MAP = Maps.newHashMap();

    @OnlyIn(value=Dist.CLIENT)
    public static void loadModel(ResourceLocation modelLocation, JsonElement element) {
        BedrockModelPOJO pojo = (BedrockModelPOJO)CustomPackLoader.GSON.fromJson(element, BedrockModelPOJO.class);
        if (pojo.getFormatVersion() == null) {
            return;
        }
        if (BedrockVersion.isLegacyVersion((BedrockModelPOJO)pojo) && pojo.getGeometryModelLegacy() != null) {
            MODEL_MAP.put(modelLocation, new UmamusumeTLMModel(pojo));
            return;
        }
        if (BedrockVersion.isNewVersion((BedrockModelPOJO)pojo) && pojo.getGeometryModelNew() != null) {
            MODEL_MAP.put(modelLocation, new UmamusumeTLMModel(pojo));
        }
    }
}

