/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.uma_maid.network;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tracen.uma_maid.utils.IPreviousItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public record SyncBaublePacket(int id, int index, ItemStack bauble, ItemStack previous) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBaublePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"uma_maid", (String)"sync_bauble"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBaublePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncBaublePacket::id, (StreamCodec)ByteBufCodecs.INT, SyncBaublePacket::index, (StreamCodec)ItemStack.STREAM_CODEC, SyncBaublePacket::bauble, (StreamCodec)ItemStack.STREAM_CODEC, SyncBaublePacket::previous, SyncBaublePacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncBaublePacket payload, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> SyncBaublePacket.syncItem(payload));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void syncItem(SyncBaublePacket message) {
        EntityMaid maid;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Entity e = mc.level.getEntity(message.id);
        if (e instanceof EntityMaid && (maid = (EntityMaid)e).isAlive()) {
            maid.getMaidBauble().setStackInSlot(message.index, message.bauble);
            IPreviousItemHandler handler = (IPreviousItemHandler)maid.getMaidBauble();
            handler.setPreviousStack(message.previous);
        }
    }
}

