/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.uma_maid.client;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class UmamusumeTLMModel
extends BedrockModel<Mob> {
    private final BedrockPart head;
    private final List<BedrockPart> longHairParts;

    public UmamusumeTLMModel(BedrockModelPOJO pojo) {
        super(pojo, BedrockVersion.isLegacyVersion((BedrockModelPOJO)pojo) ? BedrockVersion.LEGACY : BedrockVersion.NEW);
        this.getModelMap().put("armLeft", this.getModelMap().getOrDefault("left_arm", new BedrockPart()));
        this.getModelMap().put("legLeft", this.getModelMap().getOrDefault("left_leg", new BedrockPart()));
        this.getModelMap().put("legRight", this.getModelMap().getOrDefault("right_leg", new BedrockPart()));
        this.getModelMap().put("armRight", this.getModelMap().getOrDefault("right_arm", new BedrockPart()));
        this.getModelMap().put("left_arm", new BedrockPart());
        this.getModelMap().put("left_leg", new BedrockPart());
        this.getModelMap().put("right_leg", new BedrockPart());
        this.getModelMap().put("right_arm", new BedrockPart());
        this.head = this.getModelMap().getOrDefault("head", new BedrockPart());
        if (this.getModelMap().get("hat") != null) {
            this.head.addChild((BedrockPart)this.getModelMap().get("hat"));
            this.shouldRender.remove(this.getModelMap().get("hat"));
        }
        this.modelMap.forEach((key, model) -> this.modelMapWrapper.put(key, new ModelRendererWrapper(model)));
        this.longHairParts = Lists.newArrayList();
        this.getModelMap().forEach((name, part) -> {
            if (name.startsWith("long_hair_") || "long_hair".equals(name)) {
                this.longHairParts.add((BedrockPart)part);
            }
        });
        BedrockPart backpackPos = new BedrockPart();
        backpackPos.setPos(0.0f, 1.0f, 0.0f);
        this.getModelMap().put("backpackPositioningBone", backpackPos);
        this.setRotationAngle((BedrockPart)this.getModelMap().get("armRight"), 0.0f, 0.0f, this.convertRotation(12.5f));
        this.setRotationAngle((BedrockPart)this.getModelMap().get("armLeft"), 0.0f, 0.0f, this.convertRotation(-12.5f));
    }

    public void setupAnim(Mob entityIn, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim((LivingEntity)entityIn, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        if (this.head.xRot < 0.0f) {
            this.longHairParts.forEach(part -> {
                part.xRot = -this.head.xRot;
            });
        } else {
            this.longHairParts.forEach(part -> {
                part.xRot = 0.0f;
            });
        }
        if (entityIn.isSleeping()) {
            GlWrapper.translate((double)0.0, (double)0.25, (double)0.0);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        poseStack.scale(0.85f, 0.85f, 0.85f);
        poseStack.translate(0.0, 0.25, 0.0);
        super.renderToBuffer(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

