/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.uma_maid.client;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTypeNameEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.tracen.uma_maid.UmaMaidConfig;
import net.tracen.uma_maid.UmaMaidExtension;
import net.tracen.uma_maid.client.UmamusumeTLMModel;
import net.tracen.uma_maid.utils.TLMClientUtils;
import net.tracen.uma_maid.utils.TLMUtils;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

@EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMaidRendering(RenderMaidEvent event) {
        if (!((Boolean)UmaMaidConfig.RENDER_UMAMUSUME.get()).booleanValue()) {
            return;
        }
        EntityMaid maid = event.getMaid().asStrictMaid();
        if (maid == null) {
            return;
        }
        ItemStack soul = TLMUtils.getBaubleItemInMaid(maid, UmaMaidExtension.UMA_SOUL_BAUBLES);
        if (soul.isEmpty()) {
            return;
        }
        ResourceLocation name = UmaSoulUtils.getName((ItemStack)soul);
        UmamusumeTLMModel model = TLMClientUtils.MODEL_MAP.get(name);
        if (model == null) {
            return;
        }
        event.getModelData().setModel((BedrockModel)model);
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animation -> event.getModelData().setAnimations(animation));
        event.getModelData().setInfo((MaidModelInfo)new UmaMaidModelInfo(name));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onShowMaidName(MaidTypeNameEvent event) {
        if (!((Boolean)UmaMaidConfig.RENDER_UMAMUSUME.get()).booleanValue()) {
            return;
        }
        EntityMaid maid = event.getMaid();
        ItemStack stack = TLMUtils.getBaubleItemInMaid(maid, UmaMaidExtension.UMA_SOUL_BAUBLES);
        if (!stack.isEmpty()) {
            MutableComponent name = Component.translatable((String)Util.makeDescriptionId((String)"umadata", (ResourceLocation)UmaSoulUtils.getName((ItemStack)stack)));
            event.setTypeName((Component)name);
        }
    }

    private static class UmaMaidModelInfo
    extends MaidModelInfo {
        private final ResourceLocation name;

        public UmaMaidModelInfo(ResourceLocation name) {
            this.name = name;
        }

        public String getName() {
            return this.name.toLanguageKey();
        }

        public ResourceLocation getTexture() {
            return ClientUtils.getTexture((ResourceLocation)this.name);
        }
    }
}

