/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.uma_maid.baubles;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tracen.uma_maid.network.SyncBaublePacket;
import net.tracen.uma_maid.utils.IPreviousItemHandler;
import net.tracen.uma_maid.utils.TLMUtils;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.events.SettingPropertyEvent;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class UmaSoulBaubles
implements IMaidBauble {
    public static final ResourceLocation UMASOUL_MAID_ID = ResourceLocation.fromNamespaceAndPath((String)"uma_maid", (String)"umasoul_maid");

    public UmaSoulBaubles() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTrackingPlayer(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(target instanceof EntityMaid)) {
                return;
            }
            EntityMaid maid = (EntityMaid)target;
            BaubleItemHandler handler = maid.getMaidBauble();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack bauble = handler.getStackInSlot(i);
                if (!bauble.is((Item)ItemRegistry.UMA_SOUL.get())) continue;
                IPreviousItemHandler previousHandler = (IPreviousItemHandler)handler;
                SyncBaublePacket packet = new SyncBaublePacket(maid.getId(), i, bauble, previousHandler.getPreviousStack());
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
        }
    }

    @SubscribeEvent
    public void tick(MaidTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            Multimap<Holder<Attribute>, AttributeModifier> attributeModifiers;
            ItemStack previousStack;
            EntityMaid maidEntity = (EntityMaid)livingEntity;
            IPreviousItemHandler handler = (IPreviousItemHandler)maidEntity.getMaidBauble();
            ItemStack soul = TLMUtils.getBaubleItemInMaid(maidEntity, this);
            if (!ItemStack.matches((ItemStack)soul, (ItemStack)(previousStack = handler.getPreviousStack())) && !previousStack.isEmpty()) {
                attributeModifiers = this.getAttributeModifiers(maidEntity, previousStack);
                maidEntity.getAttributes().removeAttributeModifiers(attributeModifiers);
                handler.setPreviousStack(ItemStack.EMPTY);
            }
            if (!TLMUtils.getBaubleItemInMaid(maidEntity, this).isEmpty()) {
                attributeModifiers = this.getAttributeModifiers(maidEntity, soul);
                maidEntity.getAttributes().addTransientAttributeModifiers(attributeModifiers);
                handler.setPreviousStack(soul);
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(EntityMaid maid, ItemStack stack) {
        LinkedHashMultimap atts = LinkedHashMultimap.create();
        if (!stack.is((Item)ItemRegistry.UMA_SOUL.get())) {
            return atts;
        }
        atts.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(UMASOUL_MAID_ID, this.getExactProperty(stack, (LivingEntity)maid, UmaStatusUtils.StatusType.SPEED, (Double)UmapyoiConfig.UMASOUL_MAX_SPEED.get()), (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(UMASOUL_MAID_ID, this.getExactProperty(stack, (LivingEntity)maid, UmaStatusUtils.StatusType.STRENGTH, (Double)UmapyoiConfig.UMASOUL_MAX_STRENGTH_ATTACK.get()), (Boolean)UmapyoiConfig.UMASOUL_STRENGTH_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(UMASOUL_MAID_ID, this.getExactProperty(stack, (LivingEntity)maid, UmaStatusUtils.StatusType.STAMINA, (Double)UmapyoiConfig.UMASOUL_MAX_STAMINA_HEALTH.get()), (Boolean)UmapyoiConfig.UMASOUL_STAMINA_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(UMASOUL_MAID_ID, this.getExactProperty(stack, (LivingEntity)maid, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        atts.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(UMASOUL_MAID_ID, this.getExactProperty(stack, (LivingEntity)maid, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR_TOUGHNESS.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL : AttributeModifier.Operation.ADD_VALUE));
        return atts;
    }

    public double getExactProperty(ItemStack stack, LivingEntity user, UmaStatusUtils.StatusType type, double limit) {
        double retiredValue = !stack.has((Supplier)DataComponentsTypeRegistry.UMADATA_TRAINING) ? 1.0 : 0.25;
        int rate = 0;
        switch (type) {
            case SPEED: {
                rate = UmaSoulUtils.getPropertyRate((ItemStack)stack).speed();
                break;
            }
            case STAMINA: {
                rate = UmaSoulUtils.getPropertyRate((ItemStack)stack).stamina();
                break;
            }
            case STRENGTH: {
                rate = UmaSoulUtils.getPropertyRate((ItemStack)stack).strength();
                break;
            }
            case GUTS: {
                rate = UmaSoulUtils.getPropertyRate((ItemStack)stack).guts();
                break;
            }
            case WISDOM: {
                rate = UmaSoulUtils.getPropertyRate((ItemStack)stack).wisdom();
            }
        }
        double propertyRate = 1.0 + (double)rate / 100.0;
        double totalProperty = this.propertyPercentage(stack, type);
        SettingPropertyEvent event = new SettingPropertyEvent(user, stack, retiredValue, propertyRate, totalProperty);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getResultProperty() * limit;
    }

    private double propertyPercentage(ItemStack stack, UmaStatusUtils.StatusType type) {
        int x = 0;
        switch (type) {
            case SPEED: {
                x = UmaSoulUtils.getProperty((ItemStack)stack).speed();
                break;
            }
            case STAMINA: {
                x = UmaSoulUtils.getProperty((ItemStack)stack).stamina();
                break;
            }
            case STRENGTH: {
                x = UmaSoulUtils.getProperty((ItemStack)stack).strength();
                break;
            }
            case GUTS: {
                x = UmaSoulUtils.getProperty((ItemStack)stack).guts();
                break;
            }
            case WISDOM: {
                x = UmaSoulUtils.getProperty((ItemStack)stack).wisdom();
            }
        }
        Integer statLimit = (Integer)UmapyoiConfig.STAT_LIMIT_VALUE.get();
        double denominator = 1.0 + Math.pow(Math.E, (x > statLimit ? -0.125 * (Double)UmapyoiConfig.STAT_LIMIT_REDUCTION_RATE.get() : -0.125) * (double)(x - statLimit));
        return 1.0 / denominator;
    }
}

