/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeUtils {
    private static final Vec3 FROM_ORIGIN = new Vec3(-0.5, -0.5, -0.5);

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        TouhouLittleMaid.LOGGER.info("box({}, {}, {}, {}, {}, {}),", (Object)Math.min(x1, x2), (Object)Math.min(y1, y2), (Object)Math.min(z1, z2), (Object)Math.max(x1, x2), (Object)Math.max(y1, y2), (Object)Math.max(z1, z2));
    }

    public static void printSimplified(String name, VoxelShape shape) {
        TouhouLittleMaid.LOGGER.info("Simplified: {}", (Object)name);
        shape.optimize().toAabbs().forEach(box -> VoxelShapeUtils.print(box.minX * 16.0, box.minY * 16.0, box.minZ * 16.0, box.maxX * 16.0, box.maxY * 16.0, box.maxZ * 16.0));
    }

    public static AABB rotate(AABB box, Direction side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> box;
            case Direction.UP -> new AABB(box.minX, -box.minY, -box.minZ, box.maxX, -box.maxY, -box.maxZ);
            case Direction.NORTH -> new AABB(box.minX, -box.minZ, box.minY, box.maxX, -box.maxZ, box.maxY);
            case Direction.SOUTH -> new AABB(-box.minX, -box.minZ, -box.minY, -box.maxX, -box.maxZ, -box.maxY);
            case Direction.WEST -> new AABB(box.minY, -box.minZ, -box.minX, box.maxY, -box.maxZ, -box.maxX);
            case Direction.EAST -> new AABB(-box.minY, -box.minZ, box.minX, -box.maxY, -box.maxZ, box.maxX);
        };
    }

    public static AABB rotate(AABB box, Rotation rotation) {
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> box;
            case Rotation.CLOCKWISE_90 -> new AABB(-box.minZ, box.minY, box.minX, -box.maxZ, box.maxY, box.maxX);
            case Rotation.CLOCKWISE_180 -> new AABB(-box.minX, box.minY, -box.minZ, -box.maxX, box.maxY, -box.maxZ);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(box.minZ, box.minY, -box.minX, box.maxZ, box.maxY, -box.maxX);
        };
    }

    public static AABB rotateHorizontal(AABB box, Direction side) {
        return switch (side) {
            case Direction.NORTH -> VoxelShapeUtils.rotate(box, Rotation.NONE);
            case Direction.SOUTH -> VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_180);
            case Direction.WEST -> VoxelShapeUtils.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            case Direction.EAST -> VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_90);
            default -> box;
        };
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AABB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.toAabbs();
        for (AABB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(Shapes.create((AABB)((AABB)rotateFunction.apply(sourceBoundingBox.move(VoxelShapeUtils.FROM_ORIGIN.x, VoxelShapeUtils.FROM_ORIGIN.y, VoxelShapeUtils.FROM_ORIGIN.z))).move(-VoxelShapeUtils.FROM_ORIGIN.x, -VoxelShapeUtils.FROM_ORIGIN.z, -VoxelShapeUtils.FROM_ORIGIN.z)));
        }
        return VoxelShapeUtils.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.empty(), BooleanOp.OR, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.empty(), BooleanOp.OR, true, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(Shapes.block(), BooleanOp.ONLY_FIRST, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.optimize() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, BooleanOp function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)function);
        }
        return simplify ? combinedShape.optimize() : combinedShape;
    }
}

