/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class SoundUtil {
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;

    public static SoundEvent environmentSound(EntityMaid maid, SoundEvent fallback, float probability) {
        Level world = maid.level();
        RandomSource rand = maid.getRandom();
        BlockPos pos = maid.blockPosition();
        long dayTime = world.getDayTime();
        Biome biome = (Biome)world.getBiome(pos).value();
        if (rand.nextFloat() < probability && 0L < dayTime && dayTime < 3000L) {
            return (SoundEvent)InitSounds.MAID_MORNING.get();
        }
        if (rand.nextFloat() < probability && 12000L < dayTime && dayTime < 15000L) {
            return (SoundEvent)InitSounds.MAID_NIGHT.get();
        }
        if (rand.nextFloat() < probability && world.isRaining() && SoundUtil.isRainBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_RAIN.get();
        }
        if (rand.nextFloat() < probability && world.isRaining() && SoundUtil.isSnowyBiome(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_SNOW.get();
        }
        if (rand.nextFloat() < probability && biome.coldEnoughToSnow(pos)) {
            return (SoundEvent)InitSounds.MAID_COLD.get();
        }
        if (rand.nextFloat() < probability && SoundUtil.shouldSnowGolemBurn(biome, pos)) {
            return (SoundEvent)InitSounds.MAID_HOT.get();
        }
        return fallback;
    }

    public static SoundEvent attackSound(EntityMaid maid, SoundEvent fallback, float probability) {
        RandomSource rand = maid.getRandom();
        if (rand.nextFloat() < probability) {
            return (SoundEvent)InitSounds.MAID_FIND_TARGET.get();
        }
        return fallback;
    }

    public static boolean isRainBiome(Biome biome, BlockPos pos) {
        return biome.getPrecipitationAt(pos) == Biome.Precipitation.RAIN && !SoundUtil.shouldSnowGolemBurn(biome, pos);
    }

    public static boolean isSnowyBiome(Biome biome, BlockPos pos) {
        return biome.getPrecipitationAt(pos) == Biome.Precipitation.SNOW;
    }

    private static boolean shouldSnowGolemBurn(Biome biome, BlockPos pos) {
        return biome.getTemperature(pos) > 1.0f;
    }
}

