/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import java.util.BitSet;
import net.minecraft.core.BlockPos;

public class CenterOffsetBlockPosSet {
    private final int cx;
    private final int cy;
    private final int cz;
    private final int x;
    private final int y;
    private final int z;
    private final BitSet bitset;

    public CenterOffsetBlockPosSet(int x, int y, int z, int cx, int cy, int cz) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.bitset = new BitSet(x * y * z * 8);
    }

    public void markVis(BlockPos pos) {
        int tx = pos.getX() - this.cx + this.x;
        int ty = pos.getY() - this.cy + this.y;
        int tz = pos.getZ() - this.cz + this.z;
        int index = 4 * this.x * this.y * tz + 2 * this.y * tx + ty;
        if (tx < 0 || ty < 0 || tz < 0 || tx >= this.x * 2 || ty >= this.y * 2 || tz >= this.z * 2) {
            return;
        }
        this.bitset.set(index, true);
    }

    public boolean isVis(BlockPos pos) {
        int tx = pos.getX() - this.cx + this.x;
        int ty = pos.getY() - this.cy + this.y;
        int tz = pos.getZ() - this.cz + this.z;
        if (tx < 0 || ty < 0 || tz < 0 || tx >= this.x * 2 || ty >= this.y * 2 || tz >= this.z * 2) {
            return true;
        }
        int index = 4 * this.x * this.y * tz + 2 * this.y * tx + ty;
        return this.bitset.get(index);
    }

    public boolean isVis(int ix, int iy, int iz) {
        int tx = ix - this.cx + this.x;
        int ty = iy - this.cy + this.y;
        int tz = iz - this.cz + this.z;
        if (tx < 0 || ty < 0 || tz < 0 || tx >= this.x * 2 || ty >= this.y * 2 || tz >= this.z * 2) {
            return true;
        }
        int index = 4 * this.x * this.y * tz + 2 * this.y * tx + ty;
        return this.bitset.get(index);
    }

    public void clear() {
        this.bitset.clear();
    }
}

