/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.block.BlockWChess;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WChessToServerPackage(BlockPos pos, int move, boolean maidLost, boolean playerLost) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WChessToServerPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("wchess_to_server"));
    public static final StreamCodec<ByteBuf, WChessToServerPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WChessToServerPackage::pos, (StreamCodec)ByteBufCodecs.VAR_INT, WChessToServerPackage::move, (StreamCodec)ByteBufCodecs.BOOL, WChessToServerPackage::maidLost, (StreamCodec)ByteBufCodecs.BOOL, WChessToServerPackage::playerLost, WChessToServerPackage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(WChessToServerPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (!(patt0$temp instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                Level level = sender.level;
                if (!level.isLoaded(message.pos)) {
                    return;
                }
                BlockWChess.maidMove(sender, level, message.pos, message.move, message.maidLost, message.playerLost);
            });
        }
    }
}

