/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RefreshMaidBrainPackage(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RefreshMaidBrainPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("refresh_maid_brain"));
    public static final StreamCodec<ByteBuf, RefreshMaidBrainPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RefreshMaidBrainPackage::entityId, RefreshMaidBrainPackage::new);

    public static void handle(RefreshMaidBrainPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                Player sender = context.player();
                Entity entity = sender.level.getEntity(message.entityId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    maid.refreshBrain((ServerLevel)sender.level);
                }
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

