/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.lexer;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public enum TokenKind {
    EOF,
    ERROR(Tag.HAS_VALUE),
    IDENTIFIER(Tag.HAS_VALUE),
    STRING(Tag.HAS_VALUE),
    FLOAT(Tag.HAS_VALUE),
    TRUE,
    FALSE,
    BREAK,
    CONTINUE,
    RETURN,
    DOT,
    BANG,
    AMPAMP,
    BARBAR,
    LT,
    LTE,
    GT,
    GTE,
    EQ,
    EQEQ,
    BANGEQ,
    STAR,
    SLASH,
    PLUS,
    SUB,
    LPAREN,
    RPAREN,
    LBRACE,
    RBRACE,
    QUESQUES,
    QUES,
    COLON,
    ARROW,
    LBRACKET,
    RBRACKET,
    COMMA,
    SEMICOLON;

    private final Set<Tag> tags;

    private TokenKind(Tag ... tags) {
        this.tags = EnumSet.copyOf(Arrays.asList(tags));
    }

    private TokenKind() {
        this.tags = Collections.emptySet();
    }

    public boolean hasTag(@NotNull Tag tag) {
        Objects.requireNonNull(tag, "tag");
        return this.tags.contains((Object)tag);
    }

    public static enum Tag {
        HAS_VALUE;

    }
}

