/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundAtPosPackage;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Parrot.class})
public abstract class ParrotMixin {
    @Inject(method={"imitateNearbyMobs"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;isSilent()Z")}, cancellable=true)
    private static void mobIsSilent(Level level, Entity parrot, CallbackInfoReturnable<Boolean> cir, @Local Mob mob) {
        if (mob instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)mob;
            SoundEvent soundevent = SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
            if (!level.isClientSide) {
                NetworkHandler.sendToNearby(parrot, new PlayMaidSoundAtPosPackage(soundevent.getLocation(), maid.getSoundPackId(), parrot.getX(), parrot.getY(), parrot.getZ(), 0.7f, Parrot.getPitch((RandomSource)level.random)), 16);
            }
            cir.setReturnValue((Object)true);
        }
    }
}

