/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.github.tartaricacid.touhoulittlemaid.item.ItemBoardState;
import com.github.tartaricacid.touhoulittlemaid.util.WeightedPicker;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomBoardStateFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"board_state_randomly");
    public static final MapCodec<RandomBoardStateFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> RandomBoardStateFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)Codec.STRING.listOf().fieldOf("tags").forGetter(f -> f.tags)).apply((Applicative)instance, RandomBoardStateFunction::new));
    private final List<String> tags;

    protected RandomBoardStateFunction(List<LootItemCondition> predicates, List<String> tags) {
        super(predicates);
        this.tags = tags;
    }

    public static Builder create() {
        return new Builder();
    }

    private boolean checkTags(BoardStateRecord record) {
        for (String tag : this.tags) {
            if (!record.tags().contains(tag)) continue;
            return true;
        }
        return false;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        List<BoardStateRecord> records = BoardStateData.getRecordsByItem(stack);
        if (records.isEmpty()) {
            return stack;
        }
        if (this.tags.isEmpty()) {
            return stack;
        }
        List<BoardStateRecord> matchedRecords = records.stream().filter(this::checkTags).toList();
        if (matchedRecords.isEmpty()) {
            return stack;
        }
        BoardStateRecord selected = WeightedPicker.pickRandom(matchedRecords, BoardStateRecord::weight);
        if (selected == null) {
            return stack;
        }
        BoardStateRecord.Display display = selected.display();
        ItemBoardState.setState(stack, selected.data(), display.description(), display.author());
        return stack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return InitLootModifier.BOARD_STATE_RANDOMLY.get();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<String> tags = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public LootItemFunction build() {
            return new RandomBoardStateFunction(this.getConditions(), this.tags);
        }
    }
}

