/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.vorbis;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.HighLevelOggStreamPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.IOUtils;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.audio.OggAudioInfoHeader;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.vorbis.VorbisPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.vorbis.VorbisPacketFactory;

public class VorbisInfo
extends HighLevelOggStreamPacket
implements VorbisPacket,
OggAudioInfoHeader {
    private int version;
    private int channels;
    private long rate;
    private int bitrateUpper;
    private int bitrateNominal;
    private int bitrateLower;
    private int blocksizes;

    public VorbisInfo() {
        this.version = 0;
    }

    public VorbisInfo(OggPacket pkt) {
        super(pkt);
        byte[] data = this.getData();
        this.version = (int)IOUtils.getInt4(data, 7);
        if (this.version != 0) {
            throw new IllegalArgumentException("Unsupported vorbis version " + this.version + " detected");
        }
        this.channels = data[11];
        this.rate = IOUtils.getInt4(data, 12);
        this.bitrateUpper = (int)IOUtils.getInt4(data, 16);
        this.bitrateNominal = (int)IOUtils.getInt4(data, 20);
        this.bitrateLower = (int)IOUtils.getInt4(data, 24);
        this.blocksizes = IOUtils.toInt(data[28]);
        byte framingBit = data[29];
        if (framingBit == 0) {
            throw new IllegalArgumentException("Framing bit not set, invalid");
        }
    }

    public int getHeaderSize() {
        return 7;
    }

    public void populateMetadataHeader(byte[] b, int dataLength) {
        VorbisPacketFactory.populateMetadataHeader(b, 1, dataLength);
    }

    public OggPacket write() {
        byte[] data = new byte[30];
        this.populateMetadataHeader(data, data.length);
        IOUtils.putInt4(data, 7, this.version);
        data[11] = IOUtils.fromInt(this.channels);
        IOUtils.putInt4(data, 12, this.rate);
        IOUtils.putInt4(data, 16, this.bitrateUpper);
        IOUtils.putInt4(data, 20, this.bitrateNominal);
        IOUtils.putInt4(data, 24, this.bitrateLower);
        data[28] = IOUtils.fromInt(this.blocksizes);
        data[29] = 1;
        this.setData(data);
        return super.write();
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionString() {
        return Integer.toString(this.version);
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public int getNumChannels() {
        return this.channels;
    }

    public long getRate() {
        return this.rate;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public int getSampleRate() {
        return (int)this.rate;
    }

    public int getPreSkip() {
        return 0;
    }

    public int getBitrateUpper() {
        return this.bitrateUpper;
    }

    public void setBitrateUpper(int bitrateUpper) {
        this.bitrateUpper = bitrateUpper;
    }

    public int getBitrateNominal() {
        return this.bitrateNominal;
    }

    public void setBitrateNominal(int bitrateNominal) {
        this.bitrateNominal = bitrateNominal;
    }

    public int getBitrateLower() {
        return this.bitrateLower;
    }

    public void setBitrateLower(int bitrateLower) {
        this.bitrateLower = bitrateLower;
    }

    public int getBlocksize0() {
        int part = this.blocksizes & 0xF;
        return (int)Math.pow(2.0, part);
    }

    public void setBlocksize0(int blocksize) {
        int part = (int)(Math.log(blocksize) / Math.log(2.0));
        this.blocksizes = (this.blocksizes & 0xF0) + part;
    }

    public int getBlocksize1() {
        int part = (this.blocksizes & 0xF0) >> 4;
        return (int)Math.pow(2.0, part);
    }

    public void setBlocksize1(int blocksize) {
        int part = (int)(Math.log(blocksize) / Math.log(2.0));
        this.blocksizes = (this.blocksizes & 0xF) + (part << 4);
    }
}

