/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg;

import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacket;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPacketData;
import com.github.tartaricacid.touhoulittlemaid.libs.gagravarr.ogg.OggPage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class OggPacketReader {
    private InputStream inp;
    private Iterator<OggPacketData> it;
    private OggPacket nextPacket;

    public OggPacketReader(InputStream inp) {
        this.inp = inp;
    }

    public OggPacket getNextPacket() throws IOException {
        if (this.nextPacket != null) {
            OggPacket p = this.nextPacket;
            this.nextPacket = null;
            return p;
        }
        OggPacketData leftOver = null;
        if (this.it != null && this.it.hasNext()) {
            OggPacketData packet = this.it.next();
            if (packet instanceof OggPacket) {
                return (OggPacket)packet;
            }
            leftOver = packet;
        }
        int searched = 0;
        int pos = -1;
        boolean found = false;
        while (searched < 65536 && !found) {
            int r = this.inp.read();
            if (r == -1) {
                return null;
            }
            switch (pos) {
                case -1: {
                    if (r != 79) break;
                    pos = 0;
                    break;
                }
                case 0: {
                    if (r == 103) {
                        pos = 1;
                        break;
                    }
                    pos = -1;
                    break;
                }
                case 1: {
                    if (r == 103) {
                        pos = 2;
                        break;
                    }
                    pos = -1;
                    break;
                }
                case 2: {
                    if (r == 83) {
                        found = true;
                        break;
                    }
                    pos = -1;
                }
            }
            if (found) continue;
            ++searched;
        }
        if (!found) {
            throw new IOException("Next ogg packet header not found after searching " + searched + " bytes");
        }
        if ((searched -= 3) > 0) {
            System.err.println("Warning - had to skip " + searched + " bytes of junk data before finding the next packet header");
        }
        try {
            OggPage page = new OggPage(this.inp);
            if (!page.isChecksumValid()) {
                System.err.println("Warning - invalid checksum on page " + page.getSequenceNumber() + " of stream " + Integer.toHexString(page.getSid()) + " (" + page.getSid() + ")");
            }
            this.it = page.getPacketIterator(leftOver);
            return this.getNextPacket();
        }
        catch (EOFException eof) {
            System.err.println("Warning - data ended mid-page: " + eof.getMessage());
            return null;
        }
    }

    public OggPacket getNextPacketWithSid(int sid) throws IOException {
        OggPacket p = null;
        while ((p = this.getNextPacket()) != null) {
            if (p.getSid() != sid) continue;
            return p;
        }
        return null;
    }

    public void unreadPacket(OggPacket packet) {
        if (this.nextPacket != null) {
            throw new IllegalStateException("Can't un-read twice");
        }
        this.nextPacket = packet;
    }

    public void skipToSequenceNumber(int sid, int sequenceNumber) throws IOException {
        OggPacket p = null;
        while ((p = this.getNextPacket()) != null) {
            if (p.getSid() != sid || p.getSequenceNumber() < sequenceNumber) continue;
            this.nextPacket = p;
            break;
        }
    }

    public void skipToGranulePosition(int sid, long granulePosition) throws IOException {
        OggPacket p = null;
        while ((p = this.getNextPacket()) != null) {
            if (p.getSid() != sid || p.getGranulePosition() < granulePosition) continue;
            this.nextPacket = p;
            break;
        }
    }
}

