/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityThrowPowerPoint;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemPowerPoint
extends Item {
    public ItemPowerPoint() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_BOTTLE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!world.isClientSide) {
            EntityThrowPowerPoint powerPoint = new EntityThrowPowerPoint(world, (LivingEntity)player);
            powerPoint.setItem(stack);
            powerPoint.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.7f, 1.0f);
            world.addFreshEntity((Entity)powerPoint);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }
}

