/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.MaidRayTraceHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ItemCamera
extends Item {
    public static final String MAID_INFO = "MaidInfo";

    public ItemCamera() {
        super(new Item.Properties().stacksTo(1).durability(50));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            int searchDistance = 8;
            ItemStack camera = playerIn.getItemInHand(handIn);
            Optional<EntityMaid> result = MaidRayTraceHelper.rayTraceMaid(playerIn, searchDistance);
            if (result.isPresent()) {
                EntityMaid maid = result.get();
                if (!worldIn.isClientSide && maid.isAlive() && maid.isOwnedBy((LivingEntity)playerIn) && !maid.isSleeping()) {
                    this.spawnMaidPhoto(worldIn, maid, playerIn);
                    maid.discard();
                    playerIn.getCooldowns().addCooldown((Item)this, 20);
                    camera.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "photo_maid");
                    }
                }
                maid.spawnExplosionParticle();
                playerIn.playSound((SoundEvent)InitSounds.CAMERA_USE.get(), 1.0f, 1.0f);
                return InteractionResultHolder.sidedSuccess((Object)camera, (boolean)worldIn.isClientSide);
            }
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public static void spawnMaidPhoto(Level worldIn, CompoundTag data, Player playerIn) {
        Object t;
        ItemStack photo = ((Item)InitItems.PHOTO.get()).getDefaultInstance();
        CompoundTag maidTag = new CompoundTag();
        Optional optional = EntityType.create((CompoundTag)data, (Level)worldIn);
        if (optional.isEmpty() || !((t = optional.get()) instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)t;
        maid.setHomeModeEnable(false);
        maid.saveWithoutId(maidTag);
        maidTag.putString("id", Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, photo, maidTag);
        NeoForge.EVENT_BUS.post((Event)event);
        photo.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)maidTag));
        ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)photo);
    }

    private void spawnMaidPhoto(Level worldIn, EntityMaid maid, Player playerIn) {
        ItemStack photo = ((Item)InitItems.PHOTO.get()).getDefaultInstance();
        CompoundTag maidTag = new CompoundTag();
        maid.setHomeModeEnable(false);
        maid.saveWithoutId(maidTag);
        maidTag.putString("id", Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)((EntityType)InitEntities.MAID.get()))).toString());
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, photo, maidTag);
        NeoForge.EVENT_BUS.post((Event)event);
        photo.set(InitDataComponent.MAID_INFO, (Object)CustomData.of((CompoundTag)maidTag));
        Containers.dropItemStack((Level)worldIn, (double)playerIn.getX(), (double)playerIn.getY(), (double)playerIn.getZ(), (ItemStack)photo);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (stack.getItem() == this && target.isAlive() && target instanceof EntityMaid && ((EntityMaid)target).isOwnedBy((LivingEntity)playerIn)) {
            this.use(playerIn.level, playerIn, hand);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, playerIn, target, hand);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.camera.desc").withStyle(ChatFormatting.DARK_GREEN));
    }
}

