/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.extended.LivingEntityRendererAccessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public abstract class GeoReplacedEntityRenderer<T extends LivingEntity, E extends AnimatableEntity<T>>
extends LivingEntityRenderer<T, HumanoidModel<T>>
implements IGeoRenderer<T> {
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList();
    protected AnimatableEntity<T> currentAnimatable;
    protected float widthScale = 1.0f;
    protected float heightScale = 1.0f;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected MultiBufferSource rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new HumanoidModel(renderManager.bakeLayer(ModelLayers.PLAYER)), 0.5f);
    }

    public static int getPackedOverlay(LivingEntity entity, float u) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    private static float getFacingAngle(Direction facingIn) {
        return switch (facingIn) {
            case Direction.SOUTH -> 90.0f;
            case Direction.NORTH -> 270.0f;
            case Direction.EAST -> 180.0f;
            default -> 0.0f;
        };
    }

    private static void renderLeashPiece(VertexConsumer buffer, Matrix4f positionMatrix, float xDif, float yDif, float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight, int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = (float)segment / 24.0f;
        int lerpBlockLight = (int)Mth.lerp((float)piecePosPercent, (float)entityBlockLight, (float)holderBlockLight);
        int lerpSkyLight = (int)Mth.lerp((float)piecePosPercent, (float)entitySkyLight, (float)holderSkyLight);
        int packedLight = LightTexture.pack((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;
        buffer.addVertex(positionMatrix, x - xOffset, y + yOffset, z + zOffset).setColor(red, green, blue, 1.0f).setLight(packedLight);
        buffer.addVertex(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).setColor(red, green, blue, 1.0f).setLight(packedLight);
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.renderEarlyMat = new Matrix4f((Matrix4fc)poseStack.last().pose());
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.render(entity, this.getAnimatableEntity(entity), entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(T entity, E animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction direction;
        Entity entity2;
        Mob mob;
        Entity leashHolder;
        this.currentAnimatable = animatable;
        this.dispatchedMat = new Matrix4f((Matrix4fc)poseStack.last().pose());
        boolean shouldSit = entity.isPassenger() && entity.getVehicle() != null && entity.getVehicle().shouldRiderSit();
        this.setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);
        if (((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, (LivingEntityRenderer)this, partialTick, poseStack, bufferSource, packedLight))).isCanceled()) {
            return;
        }
        poseStack.pushPose();
        if (entity instanceof Mob && (leashHolder = (mob = (Mob)entity).getLeashHolder()) != null) {
            this.renderLeash(entity, partialTick, poseStack, bufferSource, leashHolder);
        }
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.isBaby();
        float lerpBodyRot = Mth.rotLerp((float)partialTick, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot);
        float lerpHeadRot = Mth.rotLerp((float)partialTick, (float)((LivingEntity)entity).yHeadRotO, (float)((LivingEntity)entity).yHeadRot);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            lerpBodyRot = Mth.rotLerp((float)partialTick, (float)vehicle.yBodyRotO, (float)vehicle.yBodyRot);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (entity.getPose() == Pose.SLEEPING && (direction = entity.getBedOrientation()) != null) {
            float eyeOffset = entity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * eyeOffset, 0.0f, (float)(-direction.getStepZ()) * eyeOffset);
        }
        float lerpedAge = (float)((LivingEntity)entity).tickCount + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.setupRotations(entity, poseStack, lerpedAge, lerpBodyRot, partialTick, entity.getScale());
        this.preRenderCallback((LivingEntity)entity, poseStack, partialTick);
        if (!shouldSit && entity.isAlive()) {
            limbSwingAmount = ((LivingEntity)entity).walkAnimation.speed(partialTick);
            limbSwing = ((LivingEntity)entity).walkAnimation.position(partialTick);
            if (entity.isBaby()) {
                limbSwing *= 3.0f;
            }
        }
        float headPitch = Mth.lerp((float)partialTick, (float)((LivingEntity)entity).xRotO, (float)entity.getXRot());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -Mth.clamp((float)Mth.wrapDegrees((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        AnimationEvent<E> predicate = new AnimationEvent<E>(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount <= this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        AnimationContext<T> ctx = new AnimationContext<T>(entity, this.currentAnimatable, predicate, entityModelData);
        ((AnimatableEntity)animatable).setCustomAnimations(ctx, predicate);
        AnimatedGeoModel model = ((AnimatableEntity)animatable).getCurrentModel();
        if (model != null) {
            poseStack.translate(0.0f, 0.01f, 0.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation(entity));
            Color renderColor = this.getRenderColor(entity, partialTick, poseStack, bufferSource, null, packedLight);
            RenderType renderType = this.getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation(entity));
            if (Minecraft.getInstance().player != null && !entity.isInvisibleTo((Player)Minecraft.getInstance().player)) {
                VertexConsumer translucentBuffer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity)));
                this.render(model, entity, partialTick, renderType, poseStack, bufferSource, translucentBuffer, packedLight, GeoReplacedEntityRenderer.getPackedOverlay(entity, this.getOverlayProgress((LivingEntity)entity, partialTick)), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
            }
        }
        if (!entity.isSpectator()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick, lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.popPose();
        ((LivingEntityRendererAccessor)((Object)this)).tlm$renderNameTag((LivingEntity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, (LivingEntityRenderer)this, partialTick, poseStack, bufferSource, packedLight));
    }

    protected float getOverlayProgress(LivingEntity entity, float partialTicks) {
        return 0.0f;
    }

    protected void preRenderCallback(LivingEntity entity, PoseStack poseStack, float partialTick) {
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(T entity) {
        return ((AnimatableEntity)this.getAnimatableEntity(entity)).getTextureLocation();
    }

    protected void setupRotations(T pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float pScale) {
        super.setupRotations(pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks, pScale);
        if (((LivingEntity)pEntityLiving).deathTime <= 0 && pEntityLiving.isAutoSpinAttack()) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)pEntityLiving).tickCount + pPartialTicks) * 75.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f + pEntityLiving.getXRot()));
        }
    }

    protected boolean isVisible(LivingEntity entity) {
        return !entity.isInvisible();
    }

    protected float getDeathMaxRotation(LivingEntity entity) {
        return 90.0f;
    }

    public boolean shouldShowName(T entity) {
        double nameRenderDistance;
        double d = nameRenderDistance = entity.isDiscrete() ? 32.0 : 64.0;
        if (this.entityRenderDispatcher.distanceToSqr(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity.shouldShowName() || entity == this.entityRenderDispatcher.crosshairPickEntity && entity.hasCustomName() && Minecraft.renderNames();
    }

    protected float getSwingProgress(LivingEntity entity, float partialTick) {
        return entity.getAttackAnim(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    public final boolean addLayer(GeoLayerRenderer<T, ?> layer) {
        return this.layerRenderers.add(layer);
    }

    public abstract E getAnimatableEntity(T var1);

    public <E extends Entity> void renderLeash(T entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, E leashHolder) {
        int segment;
        double lerpBodyAngle = Mth.lerp((float)partialTick, (float)((LivingEntity)entity).yBodyRot, (float)((LivingEntity)entity).yBodyRotO) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = entity.getLeashOffset(1.0f);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.z + Math.sin(lerpBodyAngle) * leashOffset.x;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.z - Math.cos(lerpBodyAngle) * leashOffset.x;
        double lerpOriginX = Mth.lerp((double)partialTick, (double)((LivingEntity)entity).xo, (double)entity.getX()) + xAngleOffset;
        double lerpOriginY = Mth.lerp((double)partialTick, (double)((LivingEntity)entity).yo, (double)entity.getY()) + leashOffset.y;
        double lerpOriginZ = Mth.lerp((double)partialTick, (double)((LivingEntity)entity).zo, (double)entity.getZ()) + zAngleOffset;
        Vec3 ropeGripPosition = leashHolder.getRopeHoldPosition(partialTick);
        float xDif = (float)(ropeGripPosition.x - lerpOriginX);
        float yDif = (float)(ropeGripPosition.y - lerpOriginY);
        float zDif = (float)(ropeGripPosition.z - lerpOriginZ);
        float offsetMod = (float)Mth.fastInvSqrt((double)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.leash());
        BlockPos entityEyePos = BlockPos.containing((Position)entity.getEyePosition(partialTick));
        BlockPos holderEyePos = BlockPos.containing((Position)leashHolder.getEyePosition(partialTick));
        int entityBlockLight = this.getBlockLightLevel((Entity)entity, entityEyePos);
        int holderBlockLight = leashHolder.isOnFire() ? 15 : leashHolder.level().getBrightness(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = entity.level().getBrightness(LightLayer.SKY, entityEyePos);
        int holderSkyLight = entity.level().getBrightness(LightLayer.SKY, holderEyePos);
        poseStack.pushPose();
        poseStack.translate(xAngleOffset, leashOffset.y, zAngleOffset);
        Matrix4f posMatrix = poseStack.last().pose();
        for (segment = 0; segment <= 24; ++segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            GeoReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.popPose();
    }

    @Override
    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(MultiBufferSource bufferSource) {
        this.rtb = bufferSource;
    }

    public List<GeoLayerRenderer> getLayerRenderers() {
        return this.layerRenderers;
    }
}

