/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber
public final class EntityHurtEvent {
    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent event) {
        Entity attacker = event.getProjectile().getOwner();
        HitResult ray = event.getRayTraceResult();
        if (attacker instanceof TamableAnimal) {
            TamableAnimal thrower = (TamableAnimal)attacker;
            if (ray instanceof EntityHitResult) {
                LivingEntity livingVictim;
                TamableAnimal tameable;
                EntityHitResult hitResult = (EntityHitResult)ray;
                Entity victim = hitResult.getEntity();
                if (victim instanceof TamableAnimal && (tameable = (TamableAnimal)victim).getOwnerUUID() != null && tameable.getOwnerUUID().equals(thrower.getOwnerUUID())) {
                    event.setCanceled(true);
                }
                if (victim instanceof LivingEntity && thrower.isAlliedTo((Entity)(livingVictim = (LivingEntity)victim))) {
                    event.setCanceled(true);
                }
                ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)victim.getType());
                if (((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

