/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task.crop;

import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class NetherWartCropHandler
implements ISpecialCropHandler {
    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        return (Integer)cropState.getValue((Property)NetherWartBlock.AGE) >= 3;
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState, boolean isDestroyMode) {
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else {
            ItemStack dropItemStack;
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);
            ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)(dropItemStack = new ItemStack((ItemLike)Items.NETHER_WART)), (boolean)false);
            if (!remindItemStack.isEmpty()) {
                Block.popResource((Level)maid.level, (BlockPos)cropPos, (ItemStack)remindItemStack);
            }
            maid.level.levelEvent(2001, cropPos, Block.getId((BlockState)cropState));
            maid.level.setBlock(cropPos, Blocks.NETHER_WART.defaultBlockState(), 3);
            maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
        }
    }
}

