/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.crop.SpecialCropManager;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class TaskNormalFarm
implements IFarmTask {
    private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"farm");

    @Override
    public ResourceLocation getUid() {
        return NAME;
    }

    @Override
    public ItemStack getIcon() {
        return Items.IRON_HOE.getDefaultInstance();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        Item item = stack.getItem();
        ISpecialCropHandler handler = SpecialCropManager.getItemSeedHandlers().get(item);
        if (handler != null) {
            return handler.isSeed(stack);
        }
        return stack.is(TagItem.MAID_PLANTABLE_SEEDS) && stack.getItem() instanceof ItemNameBlockItem;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        CropBlock crop;
        Block block = cropState.getBlock();
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(block);
        if (handler != null) {
            return handler.canHarvest(maid, cropPos, cropState);
        }
        return block instanceof CropBlock && (crop = (CropBlock)block).isMaxAge(cropState);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        boolean isDestroyMode = maid.getMainHandItem().getItem() instanceof HoeItem;
        Block cropBlock = cropState.getBlock();
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(cropBlock);
        if (handler != null) {
            handler.harvest(maid, cropPos, cropState, isDestroyMode);
            return;
        }
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else if (cropBlock instanceof CropBlockAccessor) {
            CropBlockAccessor crop = (CropBlockAccessor)cropBlock;
            BlockEntity blockEntity = cropState.hasBlockEntity() ? maid.level.getBlockEntity(cropPos) : null;
            maid.dropResourcesToMaidInv(cropState, maid.level, cropPos, blockEntity, maid, maid.getMainHandItem());
            maid.level.levelEvent(2001, cropPos, Block.getId((BlockState)cropState));
            if (cropState.hasProperty((Property)crop.tlmAgeProperty())) {
                try {
                    cropState = (BlockState)cropState.trySetValue((Property)crop.tlmAgeProperty(), (Comparable)Integer.valueOf(0));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            maid.level.setBlock(cropPos, cropState, 3);
            maid.level.gameEvent((Entity)maid, (Holder)GameEvent.BLOCK_CHANGE, cropPos);
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        ISpecialCropHandler handler = SpecialCropManager.getBlockCropHandlers().get(baseState.getBlock());
        if (handler != null) {
            return handler.canPlant(maid, basePos, baseState, seed);
        }
        BlockPos abovePos = basePos.above();
        BlockState aboveState = maid.level.getBlockState(abovePos);
        if (!aboveState.canBeReplaced() || aboveState.liquid()) {
            return false;
        }
        Item item = seed.getItem();
        if (item instanceof ItemNameBlockItem) {
            ItemNameBlockItem blockNamedItem = (ItemNameBlockItem)item;
            BlockState plantBlockState = blockNamedItem.getBlock().defaultBlockState();
            return plantBlockState.canSurvive((LevelReader)maid.level, abovePos);
        }
        return false;
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        Item item = seed.getItem();
        ISpecialCropHandler handler = SpecialCropManager.getItemSeedHandlers().get(item);
        if (handler != null) {
            return handler.plant(maid, basePos, baseState, seed);
        }
        if (item instanceof ItemNameBlockItem) {
            maid.placeItemBlock(basePos.above(), seed);
        }
        return seed;
    }
}

