/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFeedTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedOwnerTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.common.EffectCures;

public class TaskFeedOwner
implements IFeedTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"feed");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.COOKED_BEEF.getDefaultInstance();
    }

    @Override
    public boolean isFood(ItemStack stack, Player owner) {
        FoodProperties food;
        if (stack.getItem() == Items.MILK_BUCKET) {
            for (MobEffectInstance effect2 : owner.getActiveEffects()) {
                if (!this.isHarmfulEffect(effect2) || effect2.getDuration() <= 60 || !effect2.getCures().contains(EffectCures.MILK)) continue;
                return true;
            }
            return false;
        }
        if (stack.getItem().getFoodProperties(stack, (LivingEntity)owner) != null && (food = stack.getItem().getFoodProperties(stack, (LivingEntity)owner)) != null) {
            return food.effects().isEmpty() || food.effects().stream().noneMatch(effect -> this.isHarmfulEffect(effect.effect()));
        }
        return false;
    }

    @Override
    public IFeedTask.Priority getPriority(ItemStack stack, Player owner) {
        if (stack.is(Items.MILK_BUCKET)) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.is(Items.HONEY_BOTTLE) && owner.hasEffect(MobEffects.POISON)) {
            return IFeedTask.Priority.HIGH;
        }
        if (stack.is(Items.GOLDEN_APPLE)) {
            if (owner.getHealth() * 2.0f < owner.getMaxHealth()) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOWEST;
        }
        if (stack.getItem().getFoodProperties(stack, (LivingEntity)owner) != null) {
            int hunger;
            FoodData foodData = owner.getFoodData();
            if (!foodData.needsFood()) {
                return IFeedTask.Priority.LOWEST;
            }
            FoodProperties food = stack.getItem().getFoodProperties(stack, (LivingEntity)owner);
            int heal = 0;
            if (food != null) {
                heal = food.nutrition();
            }
            if (heal >= (hunger = 20 - foodData.getFoodLevel())) {
                return IFeedTask.Priority.HIGH;
            }
            return IFeedTask.Priority.LOW;
        }
        return IFeedTask.Priority.NONE;
    }

    @Override
    public ItemStack feed(ItemStack stack, Player owner) {
        if (stack.getUseAnimation() == UseAnim.DRINK) {
            owner.level.playSound(null, (Entity)owner, stack.getDrinkingSound(), SoundSource.NEUTRAL, 0.5f, owner.level.getRandom().nextFloat() * 0.1f + 0.9f);
        }
        return stack.getItem().finishUsingItem(stack, owner.level, (LivingEntity)owner);
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_FEED.get(), 0.3f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedOwnerTask(this, 2, 0.6f)))});
    }

    private boolean isHarmfulEffect(MobEffectInstance effect) {
        return ((MobEffect)effect.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL;
    }
}

