/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHakureiGohei;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TaskDanmakuAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"danmaku_attack");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).getDefaultInstance();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_DANMAKU_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(this::hasGohei, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> !this.hasGohei(maid) || this.farAway((LivingEntity)target, maid));
        MaidShootTargetTask shootTargetTask = new MaidShootTargetTask(2);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, LivingEntity target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.DANMAKU_RANGE);
    }

    @Override
    public AABB searchDimension(EntityMaid maid) {
        if (this.hasGohei(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.hasRestriction()) {
                return new AABB(maid.getRestrictCenter()).inflate((double)searchRange);
            }
            return maid.getBoundingBox().inflate((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.DANMAKU_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
        shooter.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).ifPresent(livingEntities -> {
            ItemStack mainHandItem = shooter.getMainHandItem();
            if (ItemHakureiGohei.isGohei(mainHandItem)) {
                long entityCount = livingEntities.stream().filter(test -> this.enemyEntityTest(shooter, target, (LivingEntity)test)).count();
                Level level = shooter.level();
                AttributeInstance attackDamage = shooter.getAttribute(Attributes.ATTACK_DAMAGE);
                float attackValue = 2.0f;
                if (attackDamage != null) {
                    attackValue = (float)attackDamage.getBaseValue();
                }
                RegistryAccess access = shooter.level.registryAccess();
                int impedingLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.IMPEDING, mainHandItem);
                int speedyLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.SPEEDY, mainHandItem);
                int multiShotLevel = EnchantmentKeys.getEnchantmentLevel(access, (ResourceKey<Enchantment>)Enchantments.MULTISHOT, mainHandItem);
                int endersEnderLevel = EnchantmentKeys.getEnchantmentLevel(access, EnchantmentKeys.ENDERS_ENDER, mainHandItem);
                float speed = 0.3f * (distanceFactor + 1.0f) * (float)(speedyLevel + 1);
                boolean hurtEnderman = endersEnderLevel > 0;
                float distance = shooter.distanceTo((Entity)target);
                speed += Mth.clamp((float)(distance / 40.0f - 0.4f), (float)0.0f, (float)2.4f);
                float inaccuracy = 1.0f - Mth.clamp((float)(distance / 100.0f), (float)0.0f, (float)0.8f);
                if (entityCount <= 1L) {
                    if (multiShotLevel > 0) {
                        DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy).setFanNum(3).setYawTotal(0.2617993877991494).setImpedingLevel(impedingLevel).fanShapedShot();
                    } else {
                        DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.0f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setImpedingLevel(impedingLevel).aimedShot();
                    }
                } else if (entityCount <= 5L) {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.2f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(8).setYawTotal(1.0471975511965976).setImpedingLevel(impedingLevel).fanShapedShot();
                } else {
                    DanmakuShoot.create().setWorld(level).setThrower((LivingEntity)shooter).setTarget(target).setRandomColor().setRandomType().setDamage(attackValue * (distanceFactor + 1.5f)).setGravity(0.0f).setVelocity(speed).setHurtEnderman(hurtEnderman).setInaccuracy(inaccuracy / 5.0f).setFanNum(32).setYawTotal(2.0943951023931953).setImpedingLevel(impedingLevel).fanShapedShot();
                }
                mainHandItem.hurtAndBreak(1, (LivingEntity)shooter, EquipmentSlot.MAINHAND);
            }
        });
    }

    @Override
    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return ItemHakureiGohei.isGohei(stack);
    }

    private boolean enemyEntityTest(EntityMaid shooter, LivingEntity target, LivingEntity test) {
        boolean canAttack = shooter.canAttack(test);
        boolean sameType = target.getType().equals(test.getType());
        return canAttack && sameType && shooter.canSee(test);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gohei", this::hasGohei));
    }

    private boolean hasGohei(EntityMaid maid) {
        return ItemHakureiGohei.isGohei(maid.getMainHandItem());
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.distanceTo((Entity)target) > this.searchRadius(maid);
    }
}

