/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFishedEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFishing;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class MaidFishingHook
extends Projectile {
    public static final EntityType<MaidFishingHook> TYPE = EntityType.Builder.of(MaidFishingHook::new, (MobCategory)MobCategory.MISC).noSave().noSummon().sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(5).build("fishing_hook");
    protected static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(MaidFishingHook.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final int MAX_OUT_OF_WATER_TIME = 10;
    protected final RandomSource syncronizedRandom = RandomSource.create();
    protected final int luck;
    protected final int lureSpeed;
    protected boolean biting;
    protected int nibble;
    protected int timeUntilLured;
    protected int timeUntilHooked;
    protected int outOfWaterTime;
    protected int life;
    protected float fishAngle;
    protected boolean openWater = true;
    protected FishHookState currentState = FishHookState.FLYING;

    protected MaidFishingHook(EntityType<? extends MaidFishingHook> entityType, Level level, int luck, int lureSpeed) {
        super(entityType, level);
        this.noCulling = true;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public MaidFishingHook(EntityType<MaidFishingHook> entityType, Level level) {
        this(entityType, level, 0, 0);
    }

    public MaidFishingHook(EntityMaid maid, Level level, int luck, int lureSpeed, Vec3 pos) {
        this(TYPE, level, luck, lureSpeed);
        this.setOwner((Entity)maid);
        this.moveTo(pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_BITING, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_BITING.equals(key)) {
            this.biting = (Boolean)this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4 * (double)Mth.nextFloat((RandomSource)this.syncronizedRandom, (float)0.6f, (float)1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    public void lerpTo(double pX, double pY, double pZ, float pYaw, float pPitch, int pSteps) {
    }

    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level.getGameTime());
        super.tick();
        EntityMaid maid = this.getMaidOwner();
        if (maid == null) {
            this.discard();
        } else if (this.level.isClientSide || !this.shouldStopFishing(maid)) {
            if (this.lifeTick()) {
                return;
            }
            maid.getLookControl().setLookAt((Entity)this);
            this.fishingTick();
        }
    }

    protected boolean lifeTick() {
        if (this.onGround()) {
            ++this.life;
            if (this.life >= 100) {
                this.discard();
                return true;
            }
        } else {
            this.life = 0;
        }
        return false;
    }

    protected void fishingTick() {
        boolean onWaterSurface;
        BlockPos blockPos = this.blockPosition();
        FluidState fluidState = this.level.getFluidState(blockPos);
        float fluidHeight = this.getFluidHeight(fluidState, blockPos);
        boolean bl = onWaterSurface = fluidHeight > 0.0f;
        if (this.currentState == FishHookState.FLYING) {
            if (onWaterSurface) {
                this.waterSurfaceTick();
                return;
            }
        } else if (this.currentState == FishHookState.BOBBING) {
            this.bobbingTick(blockPos, fluidHeight);
            this.checkOpenWater(blockPos);
            if (onWaterSurface) {
                this.bitingTick(blockPos);
            } else {
                this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
            }
        }
        this.fallTick(fluidState);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.updateRotation();
        if (this.currentState == FishHookState.FLYING && (this.onGround() || this.horizontalCollision)) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        this.reapplyPosition();
    }

    protected void fallTick(FluidState fluidState) {
        if (!fluidState.is(FluidTags.WATER)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
    }

    protected void bitingTick(BlockPos blockPos) {
        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
        if (this.biting) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
        }
        if (!this.level.isClientSide) {
            this.catchingFish(blockPos, (ServerLevel)this.level);
        }
    }

    protected void checkOpenWater(BlockPos blockPos) {
        this.openWater = this.nibble <= 0 && this.timeUntilHooked <= 0 ? true : this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockPos);
    }

    protected float getFluidHeight(FluidState fluidState, BlockPos blockPos) {
        float fluidHeight = 0.0f;
        if (fluidState.is(FluidTags.WATER)) {
            fluidHeight = fluidState.getHeight((BlockGetter)this.level(), blockPos);
        }
        return fluidHeight;
    }

    protected void waterSurfaceTick() {
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
        this.currentState = FishHookState.BOBBING;
    }

    protected void bobbingTick(BlockPos blockPos, float fluidHeight) {
        Vec3 movement = this.getDeltaMovement();
        double bobbingY = this.getY() + movement.y - (double)blockPos.getY() - (double)fluidHeight;
        if (Math.abs(bobbingY) < 0.01) {
            bobbingY += Math.signum(bobbingY) * 0.1;
        }
        this.setDeltaMovement(movement.x * 0.9, movement.y - bobbingY * (double)this.random.nextFloat() * 0.2, movement.z * 0.9);
    }

    protected void catchingFish(BlockPos pos, ServerLevel level) {
        int time = 1;
        BlockPos abovePos = pos.above();
        if (this.random.nextFloat() < 0.25f && level.isRainingAt(abovePos)) {
            ++time;
        }
        if (this.random.nextFloat() < 0.5f && !level.canSeeSky(abovePos)) {
            --time;
        }
        if (this.nibble > 0) {
            --this.nibble;
            this.onNibble(level);
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= time;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float fishAngleRad = this.fishAngle * ((float)Math.PI / 180);
                float sin = Mth.sin((float)fishAngleRad);
                float cos = Mth.cos((float)fishAngleRad);
                double x = this.getX() + (double)(sin * (float)this.timeUntilHooked) * 0.1;
                double y = (double)Mth.floor((double)this.getY()) + 1.0;
                double z = this.getZ() + (double)(cos * (float)this.timeUntilHooked) * 0.1;
                BlockState blockState = level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z));
                this.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
            } else {
                this.spawnNibbleParticle(level);
                this.nibble = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                this.getEntityData().set(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= time;
            float probability = 0.15f;
            if (this.timeUntilLured < 20) {
                probability += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                probability += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                probability += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < probability) {
                float randomRot = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float randomNum = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double x = this.getX() + (double)(Mth.sin((float)randomRot) * randomNum) * 0.1;
                double y = (double)Mth.floor((double)this.getY()) + 1.0;
                double z = this.getZ() + (double)(Mth.cos((float)randomRot) * randomNum) * 0.1;
                BlockState blockState = level.getBlockState(BlockPos.containing((double)x, (double)(y - 1.0), (double)z));
                this.spawnSplashParticle(level, blockState, x, y, z);
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    protected void spawnSplashParticle(ServerLevel level, BlockState blockState, double x, double y, double z) {
        if (blockState.is(Blocks.WATER)) {
            level.sendParticles((ParticleOptions)ParticleTypes.SPLASH, x, y, z, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
        }
    }

    protected void spawnNibbleParticle(ServerLevel level) {
        double yOffset = this.getY() + 0.5;
        float bbWidth = this.getBbWidth();
        this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
        level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), yOffset, this.getZ(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
        level.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), yOffset, this.getZ(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
    }

    protected void spawnFishingParticle(ServerLevel level, BlockState blockState, double x, double y, double z, float sin, float cos) {
        if (blockState.is(Blocks.WATER)) {
            if (this.random.nextFloat() < 0.15f) {
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, x, y - 0.1, z, 1, (double)sin, 0.1, (double)cos, 0.0);
            }
            float sinOffset = sin * 0.04f;
            float cosOffset = cos * 0.04f;
            level.sendParticles((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0, (double)cosOffset, 0.01, (double)(-sinOffset), 1.0);
            level.sendParticles((ParticleOptions)ParticleTypes.FISHING, x, y, z, 0, (double)(-cosOffset), 0.01, (double)sinOffset, 1.0);
        }
    }

    protected void onNibble(ServerLevel level) {
        EntityMaid maid = this.getMaidOwner();
        int retrieveTime = Mth.nextInt((RandomSource)this.random, (int)2, (int)10);
        if (this.nibble <= retrieveTime && maid != null) {
            ItemStack rodItem = maid.getMainHandItem();
            int rodDamage = this.retrieve(rodItem);
            this.hurtRod(maid, rodItem, rodDamage);
            maid.swing(InteractionHand.MAIN_HAND);
            level.playSound(null, maid.getX(), maid.getY(), maid.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        }
    }

    public int retrieve(ItemStack stack) {
        EntityMaid maid = this.getMaidOwner();
        if (!this.level.isClientSide && maid != null && !this.shouldStopFishing(maid)) {
            MaidFishedEvent event = null;
            MinecraftServer server = this.level.getServer();
            int rodDamage = 0;
            if (this.nibble > 0 && server != null) {
                ServerLevel serverLevel = (ServerLevel)this.level;
                LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)maid).withLuck((float)this.luck + maid.getLuck()).create(LootContextParamSets.FISHING);
                List<ItemStack> randomItems = this.getLoot(server, lootParams);
                this.addExtraLoot(randomItems);
                event = new MaidFishedEvent(randomItems, this.onGround() ? 2 : 1, this);
                NeoForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.discard();
                    return event.getRodDamage();
                }
                this.spawnLoot(randomItems, maid);
                this.afterFishing();
                rodDamage = 1;
            }
            if (this.onGround()) {
                rodDamage = 2;
            }
            this.discard();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    @NotNull
    protected List<ItemStack> getLoot(MinecraftServer server, LootParams lootParams) {
        LootTable lootTable = server.reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
        return lootTable.getRandomItems(lootParams);
    }

    protected void spawnLoot(List<ItemStack> randomItems, EntityMaid maid) {
        LivingEntity livingEntity;
        EntityMaid maidOwner = this.getMaidOwner();
        ServerPlayer serverPlayer = null;
        if (maidOwner != null && (livingEntity = maidOwner.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerIn;
            serverPlayer = serverPlayerIn = (ServerPlayer)livingEntity;
        }
        for (ItemStack result : randomItems) {
            if (serverPlayer != null && result.is(Items.ENCHANTED_BOOK)) {
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_fishing_enchanted_book");
            }
            ItemEntity itemEntity = new ItemEntity(this.level(), maid.getX(), maid.getY() + 0.5, maid.getZ(), result);
            itemEntity.setDeltaMovement(0.0, 0.1, 0.0);
            this.level.addFreshEntity((Entity)itemEntity);
            this.level.addFreshEntity((Entity)new ExperienceOrb(maid.level(), maid.getX(), maid.getY() + 0.5, maid.getZ(), this.random.nextInt(6) + 1));
        }
    }

    protected void addExtraLoot(List<ItemStack> randomItems) {
    }

    protected void afterFishing() {
        LivingEntity livingEntity;
        EntityMaid maidOwner = this.getMaidOwner();
        if (maidOwner != null && (livingEntity = maidOwner.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "maid_fishing");
        }
    }

    protected void hurtRod(EntityMaid maid, ItemStack rodItem, int rodDamage) {
        rodItem.hurtAndBreak(rodDamage, (LivingEntity)maid, EquipmentSlot.MAINHAND);
    }

    private boolean calculateOpenWater(BlockPos pos) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int y = -1; y <= 2; ++y) {
            OpenWaterType openWaterTypeForArea = this.getOpenWaterTypeForArea(pos.offset(-2, y, -2), pos.offset(2, y, 2));
            switch (openWaterTypeForArea.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos firstPos, BlockPos secondPos) {
        return BlockPos.betweenClosedStream((BlockPos)firstPos, (BlockPos)secondPos).map(this::getOpenWaterTypeForBlock).reduce((firstType, secondType) -> firstType == secondType ? firstType : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos blockPos) {
        BlockState blockState = this.level.getBlockState(blockPos);
        if (!blockState.isAir() && !blockState.is(Blocks.LILY_PAD)) {
            FluidState fluidState = blockState.getFluidState();
            return fluidState.is(FluidTags.WATER) && fluidState.isSource() && blockState.getCollisionShape((BlockGetter)this.level(), blockPos).isEmpty() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason reason) {
        this.updateOwnerInfo(null);
        super.remove(reason);
    }

    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    public void setOwner(@Nullable Entity owner) {
        super.setOwner(owner);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable MaidFishingHook fishingHook) {
        EntityMaid maid = this.getMaidOwner();
        if (maid != null) {
            maid.fishing = fishingHook;
        }
    }

    @Nullable
    public EntityMaid getMaidOwner() {
        Entity entity = this.getOwner();
        return entity instanceof EntityMaid ? (EntityMaid)entity : null;
    }

    private boolean shouldStopFishing(EntityMaid maid) {
        boolean hasVehicle;
        ItemStack mainHandItem = maid.getMainHandItem();
        boolean hasFishingRod = mainHandItem.canPerformAction(ItemAbilities.FISHING_ROD_CAST);
        boolean isFishingTask = maid.getTask() instanceof TaskFishing;
        boolean bl = hasVehicle = maid.getVehicle() != null;
        if (!maid.isRemoved() && maid.isAlive() && hasVehicle && isFishingTask && hasFishingRod && this.distanceToSqr((Entity)maid) < 256.0) {
            return false;
        }
        this.discard();
        return true;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    public boolean canUsePortal(boolean pAllowPassengers) {
        return false;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? this.getId() : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (this.getMaidOwner() == null) {
            int dataId = packet.getData();
            TouhouLittleMaid.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.level.getEntity(dataId), (Object)dataId);
            this.kill();
        }
    }

    protected static enum FishHookState {
        FLYING,
        BOBBING;

    }

    protected static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

