/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDamage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityDanmaku
extends ThrowableProjectile {
    public static final EntityType<EntityDanmaku> TYPE = EntityType.Builder.of(EntityDanmaku::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(6).updateInterval(10).noSave().build("danmaku");
    private static final int MAX_TICKS_EXISTED = 200;
    private static final EntityDataAccessor<Integer> DANMAKU_TYPE = SynchedEntityData.defineId(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.defineId(EntityDanmaku.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int impedingLevel = 0;
    private boolean hurtEnderman = false;

    public EntityDanmaku(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityDanmaku(Level worldIn, LivingEntity throwerIn) {
        super(TYPE, throwerIn, worldIn);
    }

    public EntityDanmaku(Level worldIn, double x, double y, double z) {
        super(TYPE, x, y, z, worldIn);
    }

    private static boolean hasSameOwner(TamableAnimal tameableA, TamableAnimal tameableB) {
        if (tameableA.getOwnerUUID() == null) {
            return false;
        }
        return tameableA.getOwnerUUID().equals(tameableB.getOwnerUUID());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DANMAKU_TYPE, (Object)DanmakuType.PELLET.ordinal());
        builder.define(COLOR, (Object)DanmakuColor.RED.ordinal());
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.define(GRAVITY, (Object)Float.valueOf(0.01f));
    }

    protected void onHitBlock(BlockHitResult result) {
        BlockPos pos = result.getBlockPos();
        BlockState blockState = this.level.getBlockState(pos);
        if (!blockState.getCollisionShape((BlockGetter)this.level, pos).isEmpty()) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity livingEntity;
        Entity thrower = this.getOwner();
        Entity hit = result.getEntity();
        if (thrower instanceof TamableAnimal) {
            TamableAnimal hitTameable;
            TamableAnimal tameable = (TamableAnimal)thrower;
            if (tameable instanceof EntityMaid && hit instanceof Player) {
                this.discard();
                return;
            }
            if (hit instanceof TamableAnimal && EntityDanmaku.hasSameOwner(tameable, hitTameable = (TamableAnimal)hit)) {
                this.discard();
                return;
            }
            if (hit instanceof LivingEntity && tameable.isAlliedTo((Entity)(livingEntity = (LivingEntity)hit))) {
                this.discard();
                return;
            }
            ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)hit.getType());
            if (registryName != null && ((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                this.discard();
                return;
            }
        }
        if (thrower != null && !hit.is(thrower)) {
            DamageSource source = InitDamage.danmakuDamage(thrower, this);
            hit.hurt(source, this.getDamage());
            if (this.impedingLevel > 0 && hit instanceof LivingEntity) {
                livingEntity = (LivingEntity)hit;
                int duration = (20 + this.impedingLevel * 10) * 20;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, this.impedingLevel));
            }
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    public double getGravity() {
        return ((Float)this.entityData.get(GRAVITY)).floatValue();
    }

    public EntityDanmaku setGravityVelocity(float gravity) {
        this.entityData.set(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public DanmakuType getDanmakuType() {
        return DanmakuType.getType((Integer)this.entityData.get(DANMAKU_TYPE));
    }

    public EntityDanmaku setDanmakuType(DanmakuType type) {
        this.entityData.set(DANMAKU_TYPE, (Object)type.ordinal());
        return this;
    }

    public DanmakuColor getColor() {
        return DanmakuColor.getColor((Integer)this.entityData.get(COLOR));
    }

    public EntityDanmaku setColor(DanmakuColor color) {
        this.entityData.set(COLOR, (Object)color.ordinal());
        return this;
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public EntityDanmaku setDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public EntityDanmaku setImpedingLevel(int impedingLevel) {
        this.impedingLevel = impedingLevel;
        return this;
    }

    public EntityDanmaku setHurtEnderman(boolean hurtEnderman) {
        this.hurtEnderman = hurtEnderman;
        return this;
    }

    public boolean isHurtEnderman() {
        return this.hurtEnderman;
    }
}

