/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class MaidSwimManager {
    private static final EntityDimensions SWIMMING_DIMENSIONS = EntityDimensions.scalable((float)0.6f, (float)0.6f);
    private final EntityMaid maid;
    private boolean isEatBreatheItem = false;
    private boolean wantToSwim = false;
    private BlockPos swimTarget = null;
    private boolean readyToLand = false;
    private boolean isGoingToBreath = false;

    public MaidSwimManager(EntityMaid maid) {
        this.maid = maid;
        maid.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void resetEatBreatheItem() {
        if (this.isEatBreatheItem) {
            this.isEatBreatheItem = false;
        }
    }

    public void updateSwimming() {
        if (!this.maid.level.isClientSide) {
            this.updatePose();
        }
    }

    private void updatePose() {
        if (this.wantToSwim() && !this.maid.onGround() && !this.maid.isMaidInSittingPose() && !this.maid.isPassenger()) {
            this.maid.setSwimming(true);
            this.maid.setPose(Pose.SWIMMING);
        } else {
            this.maid.setSwimming(false);
            if (!this.maid.isSleeping()) {
                this.maid.setPose(Pose.STANDING);
            }
        }
    }

    public void setWantToSwim(boolean pSearchingForLand) {
        this.wantToSwim = pSearchingForLand;
    }

    public boolean wantToSwim() {
        return this.wantToSwim;
    }

    public boolean isEatBreatheItem() {
        return this.isEatBreatheItem;
    }

    public void setEatBreatheItem(boolean eatBreatheItem) {
        this.isEatBreatheItem = eatBreatheItem;
    }

    public EntityDimensions getSwimmingDimensions() {
        return SWIMMING_DIMENSIONS;
    }

    public void setSwimTarget(BlockPos pos) {
        this.swimTarget = pos;
    }

    @Nullable
    public BlockPos getSwimTarget() {
        if (!this.wantToSwim()) {
            return null;
        }
        return this.swimTarget;
    }

    public void setReadyToLand(boolean readyToLand) {
        this.readyToLand = readyToLand;
    }

    public boolean isReadyToLand() {
        return this.readyToLand;
    }

    public void setGoingToBreath(boolean goingToBreath) {
        this.isGoingToBreath = goingToBreath;
    }

    public boolean isGoingToBreath() {
        return this.isGoingToBreath;
    }
}

