/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.misc;

import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;

public final class DefaultMonsterType {
    public static MonsterType getMonsterType(LivingEntity target) {
        if (target instanceof Enemy) {
            return MonsterType.HOSTILE;
        }
        if (target instanceof TamableAnimal || target instanceof Npc) {
            return MonsterType.FRIENDLY;
        }
        return MonsterType.NEUTRAL;
    }

    public static boolean canAttack(EntityMaid maid, LivingEntity target, MonsterType monsterType) {
        if (monsterType == MonsterType.FRIENDLY) {
            return false;
        }
        if (monsterType == MonsterType.NEUTRAL) {
            return DefaultMonsterType.checkNeutral(maid, target);
        }
        return true;
    }

    private static boolean checkNeutral(EntityMaid maid, LivingEntity target) {
        LivingEntity livingEntity = maid.getOwner();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            LivingEntity lastHurtByMob = player.getLastHurtByMob();
            if (target.equals((Object)lastHurtByMob)) {
                return true;
            }
            LivingEntity lastHurtMob = player.getLastHurtMob();
            if (target.equals((Object)lastHurtMob)) {
                return true;
            }
        }
        LivingEntity maidLastHurtByMob = maid.getLastHurtByMob();
        return target.equals((Object)maidLastHurtByMob);
    }
}

