/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoChairEntity;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenChairGuiPackage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityChair
extends AbstractEntityFromItem {
    public static final EntityType<EntityChair> TYPE = EntityType.Builder.of(EntityChair::new, (MobCategory)MobCategory.MISC).sized(0.875f, 0.5f).clientTrackingRange(10).build("chair");
    private static final EntityDataAccessor<String> MODEL_ID = SynchedEntityData.defineId(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> MOUNTED_HEIGHT = SynchedEntityData.defineId(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> TAMEABLE_CAN_RIDE = SynchedEntityData.defineId(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(EntityChair.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";
    @OnlyIn(value=Dist.CLIENT)
    private GeckoChairEntity animatable;

    protected EntityChair(EntityType<EntityChair> type, Level worldIn) {
        super(type, worldIn);
        if (worldIn.isClientSide()) {
            this.animatable = new GeckoChairEntity(this);
        }
    }

    public EntityChair(Level worldIn) {
        this(TYPE, worldIn);
    }

    public EntityChair(Level worldIn, double x, double y, double z, float yaw) {
        this(TYPE, worldIn);
        this.setPos(x, y, z);
        this.setRot(yaw, 0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MODEL_ID, (Object)DEFAULT_MODEL_ID);
        builder.define(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        builder.define(TAMEABLE_CAN_RIDE, (Object)true);
        builder.define(OWNER_UUID, Optional.empty());
    }

    protected void pushEntities() {
        if (!this.isTameableCanRide()) {
            return;
        }
        if (!this.level.isClientSide) {
            List list = this.level.getEntitiesOfClass(TamableAnimal.class, this.getBoundingBox().expandTowards(0.0, 0.5, 0.0), e -> !e.isInSittingPose() && !e.isPassenger() && e.getPassengers().isEmpty());
            list.stream().findFirst().ifPresent(entity -> entity.startRiding((Entity)this));
        }
    }

    public boolean isPickable() {
        return !EffectiveSide.get().isServer();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (player.getItemInHand(hand).interactLivingEntity(player, (LivingEntity)this, hand).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenChairGuiPackage(this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else if (!this.level.isClientSide && this.getPassengers().isEmpty() && !player.isPassenger()) {
            player.startRiding((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AABB getBoundingBoxForCulling() {
        BedrockModel model = CustomPackLoader.CHAIR_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.getBoundingBoxForCulling();
        }
        return model.getRenderBoundingBox().move(this.position());
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, (double)this.getMountedHeight() + 0.125, 0.0);
    }

    @Override
    protected boolean canKillEntity(Player player) {
        if (((Boolean)ChairConfig.CHAIR_CAN_DESTROYED_BY_ANYONE.get()).booleanValue()) {
            return true;
        }
        return this.getOwnerUUID().map(uuid -> player.getUUID().equals(uuid)).orElse(true);
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.WOOL_BREAK;
    }

    @Override
    protected Item getWithItem() {
        return (Item)InitItems.CHAIR.get();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("model_id", 8)) {
            this.setModelId(compound.getString("model_id"));
        }
        if (compound.contains("mounted_height", 5)) {
            this.setMountedHeight(compound.getFloat("mounted_height"));
        }
        if (compound.contains("tameable_can_ride", 1)) {
            this.setTameableCanRide(compound.getBoolean("tameable_can_ride"));
        }
        if (compound.contains("owner_uuid")) {
            this.setOwnerUUID(NbtUtils.loadUUID((Tag)Objects.requireNonNull(compound.get("owner_uuid"))));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("model_id", this.getModelId());
        compound.putFloat("mounted_height", this.getMountedHeight());
        compound.putBoolean("tameable_can_ride", this.isTameableCanRide());
        this.getOwnerUUID().ifPresent(uuid -> compound.putUUID("owner_uuid", uuid));
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity firstPassenger = this.getFirstPassenger();
        if (firstPassenger instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)firstPassenger;
            return livingEntity;
        }
        return super.getControllingPassenger();
    }

    public String getModelId() {
        return (String)this.entityData.get(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.entityData.set(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.entityData.get(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = Mth.clamp((float)height, (float)-0.5f, (float)2.5f);
        this.entityData.set(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.entityData.get(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.entityData.set(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.entityData.get(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(@Nullable Player player) {
        if (player != null) {
            this.setOwnerUUID(player.getUUID());
        }
    }

    public boolean hasPassenger() {
        return !this.getPassengers().isEmpty();
    }

    public float getPassengerYaw() {
        if (!this.getPassengers().isEmpty()) {
            return ((Entity)this.getPassengers().getFirst()).getYRot();
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.getYRot();
    }

    public float getPassengerPitch() {
        if (!this.getPassengers().isEmpty()) {
            return ((Entity)this.getPassengers().getFirst()).getXRot();
        }
        return 0.0f;
    }

    @Deprecated
    public int getDim() {
        ResourceKey dim = this.level.dimension();
        if (dim.equals(Level.OVERWORLD)) {
            return 0;
        }
        if (dim.equals(Level.NETHER)) {
            return -1;
        }
        if (dim.equals(Level.END)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected ItemStack getKilledStack() {
        return ItemChair.setData(((Item)InitItems.CHAIR.get()).getDefaultInstance(), new ItemChair.Data(this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.isNoGravity()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public GeckoChairEntity getAnimatableEntity() {
        return this.animatable;
    }
}

