/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.datapack.KaomojiData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.EmojiChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public final class RandomEmoji {
    static void tick(EntityMaid maid) {
        if (!((Boolean)MaidConfig.ENABLE_EMOJI.get()).booleanValue()) {
            return;
        }
        int checkRate = (Integer)MaidConfig.EMOJI_CHECK_RATE.get();
        long offset = maid.getUUID().getLeastSignificantBits() % (long)checkRate;
        if (((long)maid.tickCount + offset) % (long)checkRate != 0L) {
            return;
        }
        ChatBubbleManager bubbleManager = maid.getChatBubbleManager();
        boolean empty = bubbleManager.getChatBubbleDataCollection().isEmpty();
        if (!empty) {
            return;
        }
        int imageWeight = (Integer)MaidConfig.IMAGE_EMOJI_WEIGHT.get();
        int kaomojiWeight = (Integer)MaidConfig.KAOMOJI_EMOJI_WEIGHT.get();
        int totalWeight = imageWeight + kaomojiWeight;
        int randomWeight = maid.getRandom().nextInt(totalWeight);
        if (randomWeight < imageWeight) {
            bubbleManager.addChatBubble(EmojiChatBubbleData.create());
        } else {
            KaomojiData.showRoutineKaomoji(maid, bubbleManager);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addHurtChatText(MaidDamageEvent event) {
        if (!((Boolean)MaidConfig.ENABLE_EMOJI.get()).booleanValue()) {
            return;
        }
        EntityMaid maid = event.getMaid();
        ChatBubbleManager bubbleManager = maid.getChatBubbleManager();
        boolean empty = bubbleManager.getChatBubbleDataCollection().isEmpty();
        if (empty) {
            KaomojiData.showHurtKaomoji(maid, bubbleManager);
        }
    }
}

