/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidPickupEntitiesTask
extends Behavior<EntityMaid> {
    private static long GLOBAL_NEXT_SCHEDULE_AT = 0L;
    private final Predicate<EntityMaid> predicate;
    private final float speedModifier;

    public MaidPickupEntitiesTask(float speedModifier) {
        this((Predicate<EntityMaid>)Predicates.alwaysTrue(), speedModifier);
    }

    public MaidPickupEntitiesTask(Predicate<EntityMaid> predicate, float speedModifier) {
        super((Map)ImmutableMap.of(InitEntities.VISIBLE_PICKUP_ENTITIES.get(), (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.predicate = predicate;
        this.speedModifier = speedModifier;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return owner.isTame() && owner.canBrainMoving() && this.predicate.test(owner);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        List<Entity> items = this.getItems(maid);
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.getNavigation().getNodeEvaluator(), worldIn, maid);
        for (Entity entity : items) {
            BlockPos blockPos = entity.blockPosition();
            if (!maid.isWithinRestriction(blockPos) || !entity.isAlive() || entity.isInWater() || !pathFinding.canPathReach(blockPos)) continue;
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)entity, (float)this.speedModifier, (int)0);
            break;
        }
        pathFinding.finish();
    }

    private List<Entity> getItems(EntityMaid maid) {
        return maid.getBrain().getMemory(InitEntities.VISIBLE_PICKUP_ENTITIES.get()).orElse(Lists.newArrayList());
    }
}

