/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModDamageTypes;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

public class GunHurtMaidEvent {
    @SubscribeEvent
    public void onMaidHurt(MaidHurtEvent event) {
        DamageSource source = event.getSource();
        EntityMaid maid = event.getMaid();
        if (maid.getOwnerUUID() == null) {
            return;
        }
        if (this.isBulletDamage(source)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGunHurt(EntityHurtByGunEvent.Pre event) {
        Entity hurtEntity = event.getHurtEntity();
        LivingEntity attacker = event.getAttacker();
        if (attacker instanceof EntityMaid) {
            Player player;
            EntityMaid maid = (EntityMaid)attacker;
            if (hurtEntity instanceof Player && maid.isAlliedTo((Entity)(player = (Player)hurtEntity))) {
                event.setCanceled(true);
            }
        }
        if (attacker instanceof Player) {
            EntityMaid maid;
            Player player = (Player)attacker;
            if (hurtEntity instanceof EntityMaid && (maid = (EntityMaid)hurtEntity).isAlliedTo((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            EntityMaid maid;
            Entity causingEntity;
            Player player = (Player)entity;
            if (this.isBulletDamage(source) && (causingEntity = source.getEntity()) instanceof EntityMaid && (maid = (EntityMaid)causingEntity).isAlliedTo((Entity)player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onExplosionDetonateEvent(ExplosionEvent.Detonate event) {
        if (event.getExplosion().getDirectSourceEntity() instanceof EntityKineticBullet) {
            event.getAffectedEntities().removeIf(e -> e instanceof EntityMaid);
        }
    }

    private boolean isBulletDamage(DamageSource source) {
        if (source.is(ModDamageTypes.BULLETS_TAG)) {
            return true;
        }
        if (source.is(DamageTypeTags.IS_EXPLOSION)) {
            Entity directEntity = source.getDirectEntity();
            return directEntity instanceof EntityKineticBullet;
        }
        return false;
    }
}

