/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.emi;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.altar.EmiAltarRecipeCategory;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.altar.EmiAltarRecipeMaker;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.transfer.BackpackRecipeHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.CraftingTableBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.FurnaceBackpackContainer;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class MaidEmiPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory ALTAR = new EmiAltarRecipeCategory();

    private void registerAltarRecipeCategory(EmiRegistry registry) {
        registry.addCategory(ALTAR);
        registry.addWorkstation(ALTAR, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)InitItems.HAKUREI_GOHEI.get())));
        registry.addWorkstation(ALTAR, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)InitItems.SANAE_GOHEI.get())));
        EmiAltarRecipeMaker.registerAltarRecipes(registry);
    }

    private void hideStacks(EmiRegistry registry) {
        ArrayList<ItemStack> groupItems = new ArrayList<ItemStack>();
        groupItems.add(((Item)InitItems.GARAGE_KIT.get()).getDefaultInstance());
        groupItems.add(((Item)InitItems.CHAIR.get()).getDefaultInstance());
        registry.removeEmiStacks(emiStack -> {
            ItemStack itemStack = emiStack.getItemStack();
            for (ItemStack groupItem : groupItems) {
                if (!itemStack.is(groupItem.getItem()) || ItemStack.matches((ItemStack)groupItem, (ItemStack)itemStack)) continue;
                return true;
            }
            return false;
        });
        for (ItemStack item : groupItems) {
            registry.addEmiStackAfter(EmiStack.of((ItemStack)item), emiStack -> emiStack.getItemStack().is((Item)InitItems.POWER_POINT.get()));
        }
    }

    private void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler(CraftingTableBackpackContainer.TYPE, new BackpackRecipeHandler(VanillaEmiRecipeCategories.CRAFTING, 62, 9, 0, 61));
        registry.addRecipeHandler(FurnaceBackpackContainer.TYPE, new BackpackRecipeHandler(VanillaEmiRecipeCategories.SMELTING, 61, 1, 0, 61));
        registry.addRecipeHandler(FurnaceBackpackContainer.TYPE, new BackpackRecipeHandler(VanillaEmiRecipeCategories.FUEL, 62, 1, 0, 61));
    }

    private void registerExclusionArea(EmiRegistry registry) {
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (!(screen instanceof AbstractMaidContainerGui)) {
                return;
            }
            AbstractMaidContainerGui maidContainerGui = (AbstractMaidContainerGui)screen;
            for (Rect2i rect2i : maidContainerGui.getExclusionArea()) {
                consumer.accept(new Bounds(rect2i.getX(), rect2i.getY(), rect2i.getWidth(), rect2i.getHeight()));
            }
        });
    }

    private void registerInfoRecipe(EmiRegistry registry) {
        registry.addRecipe((EmiRecipe)this.getInfoRecipe((Item)InitItems.GARAGE_KIT.get(), (Component)Component.translatable((String)"jei.touhou_little_maid.garage_kit.info")));
    }

    private EmiInfoRecipe getInfoRecipe(Item item, Component component) {
        return new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)item)), List.of(component), null);
    }

    public void register(EmiRegistry registry) {
        this.registerAltarRecipeCategory(registry);
        this.registerRecipeHandlers(registry);
        this.registerExclusionArea(registry);
        this.registerInfoRecipe(registry);
        this.hideStacks(registry);
    }
}

