/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.cloth;

import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.client.sound.record.MicrophoneManager;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import java.util.SortedMap;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;

public class GlobalAIIntegration {
    private static final String DEFAULT_LANGUAGE = "en_us";

    public static void aiChat(ConfigBuilder root, ConfigEntryBuilder entryBuilder) {
        ConfigCategory aiChat = root.getOrCreateCategory((Component)Component.translatable((String)"config.touhou_little_maid.global_ai"));
        GlobalAIIntegration.llmConfig(entryBuilder, aiChat);
        GlobalAIIntegration.ttsConfig(entryBuilder, aiChat);
        GlobalAIIntegration.sttConfig(entryBuilder, aiChat);
    }

    private static void sttConfig(ConfigEntryBuilder entryBuilder, ConfigCategory aiChat) {
        SubCategoryBuilder builder = entryBuilder.startSubCategory((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt"));
        builder.setExpanded(true);
        builder.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt_enable"), ((Boolean)AIConfig.STT_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.stt_enable.tooltip")}).setSaveConsumer(s -> {
            AIConfig.STT_ENABLED.set(s);
            AIConfig.STT_ENABLED.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt_type"), STTApiType.class, (Enum)((STTApiType)((Object)AIConfig.STT_TYPE.get()))).setDefaultValue((Enum)STTApiType.PLAYER2).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.stt_type.tooltip")}).setSaveConsumer(s -> {
            AIConfig.STT_TYPE.set((Object)s);
            AIConfig.STT_TYPE.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startSelector((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt_microphone"), (Object[])MicrophoneManager.getAllMicrophoneName(), (Object)((String)AIConfig.STT_MICROPHONE.get())).setDefaultValue((Object)"").setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.stt_microphone.tooltip")}).setSaveConsumer(s -> {
            AIConfig.STT_MICROPHONE.set(s);
            AIConfig.STT_MICROPHONE.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.maid_can_chat_distance"), ((Integer)AIConfig.MAID_CAN_CHAT_DISTANCE.get()).intValue(), 1, 256).setDefaultValue(12).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.maid_can_chat_distance.tooltip")}).setSaveConsumer(s -> {
            AIConfig.MAID_CAN_CHAT_DISTANCE.set(s);
            AIConfig.MAID_CAN_CHAT_DISTANCE.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.stt_proxy_address"), (String)AIConfig.STT_PROXY_ADDRESS.get()).setDefaultValue("").setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.stt_proxy_address.tooltip")}).setSaveConsumer(s -> {
            AIConfig.STT_PROXY_ADDRESS.set(s);
            AIConfig.STT_PROXY_ADDRESS.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)builder.build());
    }

    private static void ttsConfig(ConfigEntryBuilder entryBuilder, ConfigCategory aiChat) {
        SubCategoryBuilder builder = entryBuilder.startSubCategory((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts"));
        builder.setExpanded(true);
        builder.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts_enable"), ((Boolean)AIConfig.TTS_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.tts_enable.tooltip")}).setSaveConsumer(s -> {
            AIConfig.TTS_ENABLED.set(s);
            AIConfig.TTS_ENABLED.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts_proxy_address"), (String)AIConfig.TTS_PROXY_ADDRESS.get()).setDefaultValue("").setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.tts_proxy_address.tooltip")}).setSaveConsumer(s -> {
            AIConfig.TTS_PROXY_ADDRESS.set(s);
            AIConfig.TTS_PROXY_ADDRESS.save();
        }).build());
        SortedMap languages = Minecraft.getInstance().getLanguageManager().getLanguages();
        builder.add((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.tts_language"), (String)AIConfig.TTS_LANGUAGE.get(), Component::literal, GlobalAIIntegration.cell(languages)).setSelections(languages.keySet()).setDefaultValue((Object)DEFAULT_LANGUAGE).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.tts_language.tooltip")}).setSaveConsumer(s -> {
            AIConfig.TTS_LANGUAGE.set(s);
            AIConfig.TTS_LANGUAGE.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)builder.build());
    }

    private static void llmConfig(ConfigEntryBuilder entryBuilder, ConfigCategory aiChat) {
        SubCategoryBuilder builder = entryBuilder.startSubCategory((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.llm"));
        builder.setExpanded(true);
        builder.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.llm_enable"), ((Boolean)AIConfig.LLM_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.llm_enable.tooltip")}).setSaveConsumer(s -> {
            AIConfig.LLM_ENABLED.set(s);
            AIConfig.LLM_ENABLED.save();
        }).build());
        builder.add((AbstractConfigListEntry)((DoubleFieldBuilder)entryBuilder.startDoubleField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.llm_temperature"), ((Double)AIConfig.LLM_TEMPERATURE.get()).doubleValue()).setDefaultValue((Object)((Double)AIConfig.LLM_TEMPERATURE.getDefault()))).setMin(0.0).setMax(2.0).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.llm_temperature.tooltip")}).setSaveConsumer(s -> {
            AIConfig.LLM_TEMPERATURE.set(s);
            AIConfig.LLM_TEMPERATURE.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.function_call_enabled"), ((Boolean)AIConfig.FUNCTION_CALL_ENABLED.get()).booleanValue()).setDefaultValue(false).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.function_call_enabled.1.tooltip"), Component.translatable((String)"config.touhou_little_maid.global_ai.function_call_enabled.2.tooltip")}).setSaveConsumer(s -> {
            AIConfig.FUNCTION_CALL_ENABLED.set(s);
            AIConfig.FUNCTION_CALL_ENABLED.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.auto_gen_setting_enabled"), ((Boolean)AIConfig.AUTO_GEN_SETTING_ENABLED.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.auto_gen_setting_enabled.tooltip")}).setSaveConsumer(s -> {
            AIConfig.AUTO_GEN_SETTING_ENABLED.set(s);
            AIConfig.AUTO_GEN_SETTING_ENABLED.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.llm_proxy_address"), (String)AIConfig.LLM_PROXY_ADDRESS.get()).setDefaultValue("").setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.llm_proxy_address.tooltip")}).setSaveConsumer(s -> {
            AIConfig.LLM_PROXY_ADDRESS.set(s);
            AIConfig.LLM_PROXY_ADDRESS.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.llm_max_token"), ((Integer)AIConfig.LLM_MAX_TOKEN.get()).intValue()).setDefaultValue(4096).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.llm_max_token.tooltip")}).setSaveConsumer(s -> {
            AIConfig.LLM_MAX_TOKEN.set(s);
            AIConfig.LLM_MAX_TOKEN.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.maid_max_history_llm_size"), ((Integer)AIConfig.MAID_MAX_HISTORY_LLM_SIZE.get()).intValue(), 1, 128).setDefaultValue(16).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.maid_max_history_llm_size.tooltip")}).setSaveConsumer(s -> {
            AIConfig.MAID_MAX_HISTORY_LLM_SIZE.set(s);
            AIConfig.MAID_MAX_HISTORY_LLM_SIZE.save();
        }).build());
        builder.add((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.translatable((String)"config.touhou_little_maid.global_ai.max_tokens_per_player"), ((Integer)AIConfig.MAX_TOKENS_PER_PLAYER.get()).intValue()).setDefaultValue(Integer.MAX_VALUE).setTooltip(new Component[]{Component.translatable((String)"config.touhou_little_maid.global_ai.max_tokens_per_player.tooltip")}).setSaveConsumer(s -> {
            AIConfig.MAX_TOKENS_PER_PLAYER.set(s);
            AIConfig.MAX_TOKENS_PER_PLAYER.save();
        }).build());
        aiChat.addEntry((AbstractConfigListEntry)builder.build());
    }

    private static DropdownBoxEntry.SelectionCellCreator<String> cell(SortedMap<String, LanguageInfo> languages) {
        LanguageInfo defaultLanguage = (LanguageInfo)languages.get(DEFAULT_LANGUAGE);
        return new DropdownBoxEntry.DefaultSelectionCellCreator(i -> languages.getOrDefault(i, defaultLanguage).toComponent());
    }
}

