/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public final class PowerCommand {
    private static final String POWER_NAME = "power";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.literal((String)POWER_NAME);
        RequiredArgumentBuilder targets = Commands.argument((String)TARGETS_NAME, (ArgumentType)EntityArgument.players());
        RequiredArgumentBuilder count = Commands.argument((String)COUNT_NAME, (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f));
        RequiredArgumentBuilder handleType = Commands.argument((String)HANDLE_NAME, (ArgumentType)HandleTypeArgument.type());
        pack.then(Commands.literal((String)GET_NAME).then(targets.executes(PowerCommand::getPower)));
        pack.then(handleType.then(targets.then(count.executes(PowerCommand::handlePower))));
        return pack;
    }

    private static int handlePower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)TARGETS_NAME);
        float count = FloatArgumentType.getFloat(context, (String)COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (ServerPlayer player : players) {
            PowerAttachment powerAttachment = (PowerAttachment)player.getData(InitDataAttachment.POWER_NUM);
            MaidNumAttachment maidNumAttachment = (MaidNumAttachment)player.getData(InitDataAttachment.MAID_NUM);
            switch (type) {
                case "set": {
                    powerAttachment.set(count);
                    break;
                }
                case "add": {
                    powerAttachment.add(count);
                    break;
                }
                case "min": {
                    powerAttachment.min(count);
                    break;
                }
            }
            player.setData(InitDataAttachment.POWER_NUM, (Object)new PowerAttachment(powerAttachment.get()));
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncDataPackage(powerAttachment.get(), maidNumAttachment.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.touhou_little_maid.power.handle.info", (Object[])new Object[]{players.size()}), true);
        return 1;
    }

    private static int getPower(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        for (Player player : EntityArgument.getPlayers(context, (String)TARGETS_NAME)) {
            PowerAttachment power = (PowerAttachment)player.getData(InitDataAttachment.POWER_NUM);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.touhou_little_maid.power.get.info", (Object[])new Object[]{player.getScoreboardName(), Float.valueOf(power.get())}), false);
        }
        return 1;
    }
}

