/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.item.ItemCamera;
import com.github.tartaricacid.touhoulittlemaid.world.backups.MaidBackupsManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BackupCommand {
    private static final String BACKUP_NAME = "backup";
    private static final String GET_NAME = "get";
    private static final String PLAYER_NAME = "player";
    private static final String MAID_UUID = "maid_uuid";
    private static final String FILE_NAME = "file_name";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder root = Commands.literal((String)BACKUP_NAME);
        LiteralArgumentBuilder get = Commands.literal((String)GET_NAME);
        RequiredArgumentBuilder player = Commands.argument((String)PLAYER_NAME, (ArgumentType)EntityArgument.player());
        RequiredArgumentBuilder maidUuid = Commands.argument((String)MAID_UUID, (ArgumentType)UuidArgument.uuid());
        RequiredArgumentBuilder fileName = Commands.argument((String)FILE_NAME, (ArgumentType)StringArgumentType.string());
        root.then(get.then(player.executes(BackupCommand::handlePlayerMaidIndex)));
        root.then(get.then(player.then(maidUuid.executes(BackupCommand::handlePlayerMaid))));
        root.then(get.then(player.then(maidUuid.then(fileName.executes(BackupCommand::handlePlayerMaidFile)))));
        return root;
    }

    private static String getFormattedTime(long timestamp) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, ZoneOffset.UTC);
        return dateTime.format(DateTimeFormatter.ofPattern("(MM/dd HH:mm)"));
    }

    private static int handlePlayerMaidIndex(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)PLAYER_NAME);
        Map maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        if (maidIndexMap.isEmpty()) {
            MutableComponent error = Component.translatable((String)"message.touhou_little_maid.maid_backup.player.no_data", (Object[])new Object[]{player.getScoreboardName()});
            player.sendSystemMessage((Component)error.withStyle(ChatFormatting.RED));
            return 1;
        }
        maidIndexMap = maidIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(MaidBackupsManager.IndexData::timestamp).reversed())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        MutableComponent separator = Component.translatable((String)"message.touhou_little_maid.maid_backup.player.separator", (Object[])new Object[]{player.getScoreboardName()});
        player.sendSystemMessage((Component)separator.withStyle(ChatFormatting.DARK_GREEN));
        int index = 1;
        for (Map.Entry entry : maidIndexMap.entrySet()) {
            UUID id = (UUID)entry.getKey();
            MaidBackupsManager.IndexData data = (MaidBackupsManager.IndexData)entry.getValue();
            String time = "\u00a77" + BackupCommand.getFormattedTime(data.timestamp());
            MutableComponent msg = Component.literal((String)"\u00a77%d.".formatted(index)).append(CommonComponents.SPACE).append(data.name()).withStyle(ChatFormatting.GOLD).append(CommonComponents.SPACE).append(time);
            MutableComponent dimension = Component.translatable((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{data.dimension()});
            MutableComponent pos = Component.translatable((String)"tooltips.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{data.pos().toShortString()});
            String command = "/tlm backup get @s %s".formatted(id);
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)CommonComponents.joinLines((Component[])new Component[]{dimension, pos}));
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
            msg.withStyle(style -> style.withHoverEvent(hoverEvent)).withStyle(style -> style.withClickEvent(clickEvent));
            player.sendSystemMessage((Component)msg);
            ++index;
        }
        return 1;
    }

    private static int handlePlayerMaid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)PLAYER_NAME);
        UUID uuid = UuidArgument.getUuid(context, (String)MAID_UUID);
        Map<UUID, MaidBackupsManager.IndexData> maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        MaidBackupsManager.IndexData indexData = maidIndexMap.get(uuid);
        if (indexData == null) {
            MutableComponent error = Component.translatable((String)"message.touhou_little_maid.maid_backup.maid.not_found", (Object[])new Object[]{uuid});
            player.sendSystemMessage((Component)error.withStyle(ChatFormatting.RED));
            return 1;
        }
        MutableComponent separator = Component.translatable((String)"message.touhou_little_maid.maid_backup.maid.separator", (Object[])new Object[]{indexData.name()});
        player.sendSystemMessage((Component)separator.withStyle(ChatFormatting.DARK_GREEN));
        List<String> backupFiles = MaidBackupsManager.getMaidBackupFiles(player, uuid);
        for (String backupFile : backupFiles) {
            MutableComponent msg = Component.literal((String)backupFile).withStyle(ChatFormatting.DARK_PURPLE);
            String command = "/tlm backup get @s %s \"%s\"".formatted(uuid, backupFile);
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
            msg.withStyle(style -> style.withClickEvent(clickEvent));
            player.sendSystemMessage((Component)msg);
        }
        return 1;
    }

    private static int handlePlayerMaidFile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String fileName;
        UUID uuid;
        ServerPlayer player = EntityArgument.getPlayer(context, (String)PLAYER_NAME);
        CompoundTag backupData = MaidBackupsManager.getMaidBackFile(player, uuid = UuidArgument.getUuid(context, (String)MAID_UUID), fileName = StringArgumentType.getString(context, (String)FILE_NAME));
        if (backupData.isEmpty()) {
            MutableComponent error = Component.translatable((String)"message.touhou_little_maid.maid_backup.file.not_found", (Object[])new Object[]{fileName});
            player.sendSystemMessage((Component)error.withStyle(ChatFormatting.RED));
            return 1;
        }
        ItemCamera.spawnMaidPhoto(player.level, backupData, (Player)player);
        MutableComponent success = Component.translatable((String)"message.touhou_little_maid.maid_backup.file.success", (Object[])new Object[]{fileName});
        player.sendSystemMessage((Component)success.withStyle(ChatFormatting.GREEN));
        return 1;
    }
}

