/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileEntityGomokuRenderer
implements BlockEntityRenderer<TileEntityGomoku> {
    private static final ResourceLocation CHECKER_BOARD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/bedrock/block/gomoku.png");
    private static final ResourceLocation BLACK_PIECE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/bedrock/block/gomoku_black_piece.png");
    private static final ResourceLocation WHITE_PIECE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/bedrock/block/gomoku_white_piece.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final SimpleBedrockModel<Entity> CHECKER_BOARD_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.GOMOKU);
    private final SimpleBedrockModel<Entity> PIECE_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.GOMOKU_PIECE);
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;

    public TileEntityGomokuRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
        this.dispatcher = context.getBlockEntityRenderDispatcher();
    }

    public void render(TileEntityGomoku gomoku, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderChessboard(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderPiece(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderLatestChessTips(gomoku, poseStack, bufferIn, combinedLightIn);
        this.renderTipsText(gomoku, poseStack, bufferIn, combinedLightIn);
    }

    private void renderLatestChessTips(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!gomoku.getLatestChessPoint().equals(Point.NULL) && this.inRenderDistance(gomoku, 24)) {
            Camera camera = this.dispatcher.camera;
            Point point = gomoku.getLatestChessPoint();
            poseStack.pushPose();
            poseStack.translate(-0.42, 0.25, -0.42);
            poseStack.translate((double)point.x * 0.1316, 0.0, (double)point.y * 0.1316);
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f + camera.getYRot()));
            poseStack.scale(0.015625f, -0.015625f, 0.015625f);
            float width = (float)(-this.font.width("\u25bc") / 2) + 0.5f;
            this.font.drawInBatch("\u25bc", width, -1.5f, 0xFF0000, false, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
            poseStack.popPose();
        }
    }

    private void renderChessboard(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)gomoku.getBlockState().getValue((Property)BlockGomoku.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 1.5, 0.5);
        poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)(facing.get2DDataValue() * 90)));
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f));
        }
        VertexConsumer checkerBoardBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)CHECKER_BOARD_TEXTURE));
        this.CHECKER_BOARD_MODEL.renderToBuffer(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
    }

    private void renderPiece(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (this.inRenderDistance(gomoku, 24)) {
            byte[][] chessData;
            poseStack.pushPose();
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            poseStack.translate(0.92, -0.1, -1.055);
            for (byte[] row : chessData = gomoku.getChessData()) {
                for (int j = 0; j < chessData[0].length; ++j) {
                    poseStack.translate(0.0, 0.0, 0.1316);
                    if (row[j] == 1) {
                        VertexConsumer blackPieceBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)BLACK_PIECE_TEXTURE));
                        this.PIECE_MODEL.renderToBuffer(poseStack, blackPieceBuff, combinedLightIn, combinedOverlayIn);
                    }
                    if (row[j] != 2) continue;
                    VertexConsumer whitePieceBuff = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)WHITE_PIECE_TEXTURE));
                    this.PIECE_MODEL.renderToBuffer(poseStack, whitePieceBuff, combinedLightIn, combinedOverlayIn);
                }
                poseStack.translate(-0.1316, 0.0, -1.974);
            }
            poseStack.popPose();
        }
    }

    private void renderTipsText(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        Statue statue = gomoku.getStatue();
        if (statue != Statue.IN_PROGRESS && this.inRenderDistance(gomoku, 16)) {
            Camera camera = this.dispatcher.camera;
            MutableComponent resetTips = Component.translatable((String)"message.touhou_little_maid.gomoku.reset").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.AQUA);
            MutableComponent roundText = Component.translatable((String)"message.touhou_little_maid.gomoku.round", (Object[])new Object[]{gomoku.getChessCounter()}).withStyle(ChatFormatting.WHITE);
            MutableComponent preRoundIcon = Component.literal((String)"\u23f9 ").withStyle(ChatFormatting.GREEN);
            MutableComponent postRoundIcon = Component.literal((String)" \u23f9").withStyle(ChatFormatting.GREEN);
            MutableComponent roundTips = preRoundIcon.append((Component)roundText).append((Component)postRoundIcon);
            MutableComponent loseTips = statue == Statue.WIN ? (gomoku.isPlayerTurn() ? Component.translatable((String)"message.touhou_little_maid.gomoku.win").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE) : Component.translatable((String)"message.touhou_little_maid.gomoku.lose").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE)) : Component.translatable((String)"message.touhou_little_maid.gomoku.draw").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_PURPLE);
            float loseTipsWidth = -this.font.width((FormattedText)loseTips) / 2;
            float resetTipsWidth = -this.font.width((FormattedText)resetTips) / 2;
            float roundTipsWidth = -this.font.width((FormattedText)roundTips) / 2;
            poseStack.pushPose();
            poseStack.translate(0.5, 0.75, 0.5);
            poseStack.mulPose(Axis.YN.rotationDegrees(180.0f + camera.getYRot()));
            poseStack.mulPose(Axis.XN.rotationDegrees(camera.getXRot()));
            poseStack.scale(0.03f, -0.03f, 0.03f);
            this.font.drawInBatch((Component)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            this.font.drawInBatch((Component)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
            this.font.drawInBatch((Component)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.last().pose(), bufferIn, Font.DisplayMode.POLYGON_OFFSET, 0, combinedLightIn);
            poseStack.popPose();
        }
    }

    private boolean inRenderDistance(TileEntityGomoku gomoku, int distance) {
        BlockPos pos = gomoku.getBlockPos();
        return this.dispatcher.camera.getPosition().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityGomoku te) {
        return true;
    }

    public AABB getRenderBoundingBox(TileEntityGomoku blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return RenderHelper.getAABB(pos.offset(-3, 0, -3), pos.offset(3, 1, 3));
    }
}

