/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;

public class EntityYukkuriSlimeRender
extends MobRenderer<Slime, SimpleBedrockModel<Slime>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/bedrock/entity/reimu_yukkuri.png");
    private final SlimeRenderer vanillaRender;

    public EntityYukkuriSlimeRender(EntityRendererProvider.Context context) {
        super(context, Objects.requireNonNull(BedrockModelLoader.getModel(BedrockModelLoader.REIMU_YUKKURI)), 0.25f);
        this.vanillaRender = new SlimeRenderer(context);
    }

    public void render(Slime slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((Boolean)VanillaConfig.REPLACE_SLIME_MODEL.get()).booleanValue()) {
            this.renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            this.vanillaRender.render(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderYukkuri(Slime slime, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.shadowRadius = 0.25f * (float)slime.getSize();
        super.render((LivingEntity)slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    protected void scale(Slime slime, PoseStack poseStack, float partialTicks) {
        poseStack.scale(0.999f, 0.999f, 0.999f);
        poseStack.translate(0.0f, 0.001f, 0.0f);
        float slimeSize = slime.getSize();
        float tmp = Mth.lerp((float)partialTicks, (float)slime.oSquish, (float)slime.squish) / (slimeSize * 0.5f + 1.0f);
        float scale = 1.0f / (tmp + 1.0f);
        poseStack.scale(scale * slimeSize, 1.0f / scale * slimeSize, scale * slimeSize);
    }

    public ResourceLocation getTextureLocation(Slime slime) {
        return TEXTURE;
    }
}

